<?php
/**
 * Resume Post Type
 */
function my_custom_post_resume() {
    $labels = array(
        'name'               => _x( 'نمونه کارها', 'post type general name' ),
        'singular_name'      => _x( 'نمونه کار', 'post type singular name' ),
        'add_new'            => _x( 'نمونه کار جدید', 'book' ),
        'add_new_item'       => __( 'افزودن نمونه کار' ),
        'edit_item'          => __( 'ویرایش نمونه کار' ),
        'new_item'           => __( 'نمونه کار جدید' ),
        'all_items'          => __( 'همه نمونه کارها' ),
        'view_item'          => __( 'مشاهده نمونه کار' ),
        'search_items'       => __( 'جستجوی نمونه کار' ),
        'not_found'          => __( 'هیچ نمونه کاری یافت نشد!' ),
        'not_found_in_trash' => __( 'هیچ نمونه کاری در زباله دان یافت نشد!' ),
        'menu_name'          => 'نمونه کارها'
    );
    $args = array(
        'labels'        => $labels,
        'description'   => 'نمونه کارهای خود را به نمایش بگذارید.',
        'public'        => true,
        'menu_position' => 5,
        'supports'      => array( 'title', 'editor', 'thumbnail' ),
        'has_archive'   => true,
    );
    register_post_type( 'resume', $args );
}
add_action( 'init', 'my_custom_post_resume' );

/**
 * Service Post Type
 */
function my_custom_post_service() {
    $labels = array(
        'name'               => _x( 'خدمات', 'post type general name' ),
        'singular_name'      => _x( 'خدمات', 'post type singular name' ),
        'add_new'            => _x( 'خدمات جدید', 'book' ),
        'add_new_item'       => __( 'افزودن خدمات' ),
        'edit_item'          => __( 'ویرایش خدمات' ),
        'new_item'           => __( 'خدمات جدید' ),
        'all_items'          => __( 'همه خدمات' ),
        'view_item'          => __( 'مشاهده خدمات' ),
        'search_items'       => __( 'جستجوی خدمات' ),
        'not_found'          => __( 'هیچ خدماتی یافت نشد!' ),
        'not_found_in_trash' => __( 'هیچ خدماتی در زباله دان یافت نشد!' ),
        'menu_name'          => 'خدمات'
    );
    $args = array(
        'labels'        => $labels,
        'description'   => 'خدمات خود را به نمایش بگذارید.',
        'public'        => true,
        'menu_position' => 5,
        'supports'      => array( 'title', 'editor', 'excerpt' ),
        'show_in_rest' => true,
        'hierarchical'  => true
    );
    register_post_type( 'service', $args );
}
add_action( 'init', 'my_custom_post_service' );

function reg_tag() {
    register_taxonomy_for_object_type('post_tag', 'service');
}
add_action('init', 'reg_tag');