<?php $__env->startSection('content'); ?>
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <div class="page-title-left">
                                    <h2 class="mb-sm-0"><?php echo e(__('Dashboard')); ?></h2>
                                    <p><?php echo e(__('Welcome back')); ?>, <?php echo e(auth()->user()->name); ?> <span class="iconify font-24"
                                            data-icon="openmoji:waving-hand"></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-lg-4 col-xl-3">
                            <div class="dashboard-feature-item bg-off-white theme-border radius-4 p-20 mb-25">
                                <div
                                    class="dashboard-feature-item-icon-wrap font-20 d-flex align-items-center justify-content-center bg-white radius-4">
                                    <span class="iconify orange-color" data-icon="mdi:users-group"></span>
                                </div>
                                <p class="mt-2"><?php echo e(__('Total Users')); ?></p>
                                <h2 class="mt-1"><?php echo e($totalUsers); ?></h2>

                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4 col-xl-3">
                            <div class="dashboard-feature-item bg-off-white theme-border radius-4 p-20 mb-25">
                                <div
                                    class="dashboard-feature-item-icon-wrap font-20 d-flex align-items-center justify-content-center bg-white radius-4">
                                    <span class="iconify primary-color" data-icon="material-symbols:topic-outline-sharp"></span>
                                </div>
                                <p class="mt-2"><?php echo e(__('Total Usecase')); ?></p>
                                <h2 class="mt-1"><?php echo e($totalUseCase); ?></h2>

                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4 col-xl-3">
                            <div class="dashboard-feature-item bg-off-white theme-border radius-4 p-20 mb-25">
                                <div
                                    class="dashboard-feature-item-icon-wrap font-20 d-flex align-items-center justify-content-center bg-white radius-4">
                                    <span class="iconify orange-color" data-icon="material-symbols:search-rounded"></span>
                                </div>
                                <p class="mt-2"><?php echo e(__('Total Search')); ?></p>
                                <h2 class="mt-1"><?php echo e($totalSearch); ?></h2>

                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4 col-xl-3">
                            <div class="dashboard-feature-item bg-off-white theme-border radius-4 p-20 mb-25">
                                <div
                                    class="dashboard-feature-item-icon-wrap font-20 d-flex align-items-center justify-content-center bg-white radius-4">
                                    <span class="iconify green-color" data-icon="iconoir:packages"></span>
                                </div>
                                <p class="mt-2"><?php echo e(__('Total Subscription')); ?></p>
                                <h2 class="mt-1"><?php echo e($totalSubscription); ?></h2>
                            </div>
                        </div>
                    </div>
                    <!-- dashboard-feature-item row -->
                    <!-- Properties & Tickets row -->
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="dashboard-properties-table bg-off-white theme-border p-20 radius-4 mb-25">
                                <div class="">
                                    <div class="row align-items-center">
                                        <div class="col-12">
                                            <div class="d-flex align-items-center justify-content-between mb-25">
                                                <h4 class="mb-0"><?php echo e(__('Orders')); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive">
                                                <table class="table theme-border p-20">
                                                    <thead>
                                                        <tr>
                                                            <th><?php echo e(__('Package')); ?></th>
                                                            <th><?php echo e(__('Total')); ?></th>
                                                            <th><?php echo e(__('Gateway')); ?></th>
                                                            <th><?php echo e(__('Status')); ?></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <tr>
                                                                <td>
                                                                    <h6 class="theme-text-color"><?php echo e($order->packageName); ?></h6>
                                                                </td>
                                                                <td><?php echo e(currencyPrice($order->total)); ?></td>
                                                                <td><?php echo e($order->gatewayTitle); ?></td>
                                                                <td><?php echo e($order->total_tenant); ?>

                                                                    <?php if($order->payment_status == ORDER_PAYMENT_STATUS_PAID): ?>
                                                                        <div
                                                                            class="status-btn status-btn-blue font-13 radius-4">
                                                                            Paid</div>
                                                                    <?php elseif($order->payment_status == ORDER_PAYMENT_STATUS_PENDING): ?>
                                                                        <div
                                                                            class="status-btn status-btn-red font-13 radius-4">
                                                                            Pending</div>
                                                                    <?php else: ?>
                                                                        <div
                                                                            class="status-btn status-btn-orange font-13 radius-4">
                                                                            Cancelled</div>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                            <tr>
                                                                <td class="text-center"><?php echo e(__('No data found')); ?></td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    </tbody>
                                                </table>

                                                <div>
                                                    <a class="theme-link font-14 font-medium d-flex align-items-center justify-content-center mt-20"
                                                        href="<?php echo e(route('admin.subscriptions.orders')); ?>">
                                                        <?php echo e(__('View All')); ?><i class="ri-arrow-right-line ms-2"></i>
                                                    </a>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="dashboard-properties-table bg-off-white theme-border p-20 radius-4 mb-25">
                                <div class="">
                                    <div class="row align-items-center">
                                        <div class="col-12">
                                            <div class="d-flex align-items-center justify-content-between mb-25">
                                                <h4 class="mb-0"><?php echo e(__('Packages')); ?></h4>
                                                <div>
                                                    <a class="theme-link font-14 font-medium d-flex align-items-center justify-content-center"
                                                        href="<?php echo e(route('admin.packages.index')); ?>">
                                                        <?php echo e(__('View All')); ?><i class="ri-arrow-right-line ms-2"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive">
                                                <table class="table theme-border p-20">
                                                    <thead>
                                                        <tr>
                                                            <th><?php echo e(__('Name')); ?></th>
                                                            <th><?php echo e(__('Monthly Price')); ?></th>
                                                            <th><?php echo e(__('Yearly Price')); ?></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <tr>
                                                                <td>
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="flex-grow-1">
                                                                            <h6><?php echo e(Str::limit($package->name, 25, '...')); ?>

                                                                            </h6>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td><?php echo e(currencyPrice($package->monthly_price)); ?></td>
                                                                <td><?php echo e(currencyPrice($package->yearly_price)); ?></td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                            <tr>
                                                                <td class="text-center"><?php echo e(__('No data found')); ?></td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/masumbd/project/ZaiwriteAI/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>