<div class="col-md-5">
    <div class="tenant-portal-invoice-details-leftside bg-off-white theme-border p-20 radius-4 mb-25">
        <div class="row align-items-center">
            <div class="col-12">
                <div class="d-flex align-items-center justify-content-between mb-25">
                    <h4 class="mb-0"><?php echo e(__('Invoice Details')); ?></h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="table-responsive">
                    <table class="table theme-border p-20">
                        <tbody>
                            <tr>
                                <td><?php echo e(__('Name')); ?></td>
                                <td>
                                    <h6 class="tenant-invoice-tbl-right-text text-end">
                                        <?php echo e($plan->name); ?></h6>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Duration')); ?></td>
                                <td>
                                    <h6 class="tenant-invoice-tbl-right-text text-end">
                                        <?php echo e(getDurationName($durationType)); ?></h6>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Amount')); ?></td>
                                <td>
                                    <h6 class="tenant-invoice-tbl-right-text text-end">
                                        <?php if($durationType == PACKAGE_DURATION_TYPE_MONTHLY): ?>
                                            <input type="hidden" id="planAmount" value="<?php echo e($plan->monthly_price); ?>">
                                            <?php echo e(currencyPrice($plan->monthly_price)); ?>

                                    </h6>
                                <?php else: ?>
                                    <input type="hidden" id="planAmount" value="<?php echo e($plan->yearly_price); ?>">
                                    <?php echo e(currencyPrice($plan->yearly_price)); ?></h6>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Start Date')); ?></td>
                                <td>
                                    <h6 class="tenant-invoice-tbl-right-text text-end">
                                        <?php echo e($startDate); ?></h6>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('End Date')); ?></td>
                                <td>
                                    <h6 class="tenant-invoice-tbl-right-text text-end">
                                        <?php echo e($endDate); ?></h6>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <table class="table theme-border p-20">
                        <tbody id="currencyAppend"></tbody>
                    </table>
                    <table class="table theme-border p-20 d-none" id="bankAppend">
                        <tbody>
                            <tr>
                                <td><?php echo e(__('Bank Deposit')); ?></td>
                            </tr>
                            <tr>
                                <td>
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Bank Name')); ?></label>
                                    <select name="bank_id" id="bank_id" class="form-control mb-2">
                                        <option value=""><?php echo e(__('Select Option')); ?></option>
                                        <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($bank->id); ?>"
                                                data-details="<?php echo e(nl2br($bank->details)); ?>"><?php echo e($bank->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="topic-content-item d-block bg-white theme-border radius-12 m-2 d-none"
                                        id="bankDetails">
                                        <div
                                            class="topic-content-item-btns d-flex align-content-center justify-content-between">
                                            <p class="font-12 my-2 ps-2"></p>
                                        </div>
                                    </div>
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Upload Deposit Slip')); ?>

                                        (png, jpg)</label>
                                    <input type="file" name="bank_slip" id="bank_slip" class="form-control"
                                        accept="image/png, image/jpg">
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-md-7">
    <div class="row justify-content-center" id="gatewaySection">
        <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-4 mb-25">
                <div class="payment-method-item text-center h-100 theme-border radius-10">
                    <div class="payment-method-item-title bg-light">
                        <h6 class="font-11 font-semi-bold text-center"><?php echo e($gateway->title); ?></h6>
                    </div>
                    <div class="payment-method-img">
                        <img src="<?php echo e(asset($gateway->image)); ?>" alt="" class="img-fluid">
                    </div>
                    <button data-gateway=<?php echo e($gateway->slug); ?> data-id=<?php echo e($gateway->id); ?>

                        data-plan_id=<?php echo e($plan->id); ?> data-duration_type=<?php echo e($durationType); ?>

                        class="theme-btn-outline w-100 mt-25 select-payment-gateway paymentGateway">Select</button>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php /**PATH /home/khavarii/test.khavarii.com/resources/views/user/subscriptions/partials/gateway-list.blade.php ENDPATH**/ ?>