<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <div class="row">
                        <div class="col-12">
                            <div
                                class="page-title-box d-sm-flex align-items-center justify-content-between border-bottom mb-20">
                                <div class="page-title-left">
                                    <h3 class="mb-sm-0"><?php echo e(__('Settings')); ?></h3>
                                </div>
                                <div class="page-title-right">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"
                                                title="<?php echo e(__('Dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                                        <li class="breadcrumb-item"><a href="#"
                                                title="<?php echo e(__('Settings')); ?>"><?php echo e(__('Settings')); ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($pageTitle); ?></li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="settings-page-layout-wrap position-relative">
                        <div class="row">
                            <?php echo $__env->make('admin.setting.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="col-md-12 col-lg-12 col-xl-8 col-xxl-9">
                                <div class="account-settings-rightside bg-off-white theme-border radius-4 p-25">
                                    <div class="currency-settings-page-area">
                                        <div class="account-settings-content-box">
                                            <div class="account-settings-title border-bottom mb-20 pb-20">
                                                <div class="row align-items-center">
                                                    <div class="col-md-6">
                                                        <h4><?php echo e($pageTitle); ?></h4>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="property-details-right text-end">
                                                            <button type="button" class="theme-btn" id="add"
                                                                title="<?php echo e(__('Add How It Work')); ?>"><?php echo e(__('Add How It Work')); ?></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tickets-topic-table-area">
                                                <div class="table-responsive bg-white theme-border radius-4 p-25">
                                                    <table id="allDataTable"
                                                        class="table bg-white theme-border p-20 dt-responsive">
                                                        <thead>
                                                            <tr>
                                                                <th class="desktop"><?php echo e(__('SL')); ?></th>
                                                                <th class="all"><?php echo e(__('Title')); ?></th>
                                                                <th class="all"><?php echo e(__('Image')); ?></th>
                                                                <th class="all"><?php echo e(__('Status')); ?></th>
                                                                <th class="desktop"><?php echo e(__('Action')); ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $howItWorks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $howItWork): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td><?php echo e($loop->iteration); ?></td>
                                                                    <td><?php echo e($howItWork->title); ?></td>
                                                                    <td>
                                                                        <img src="<?php echo e($howItWork->image); ?>"
                                                                            class="rounded avatar-md tbl-user-image"
                                                                            alt="">
                                                                    </td>
                                                                    <td>
                                                                        <?php if($howItWork->status == ACTIVE): ?>
                                                                            <div
                                                                                class="status-btn status-btn-green font-13 radius-4">
                                                                                <?php echo e(__('Active')); ?></div>
                                                                        <?php else: ?>
                                                                            <div
                                                                                class="status-btn status-btn-red font-13 radius-4">
                                                                                <?php echo e(__('Deactive')); ?></div>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                        <div class="tbl-action-btns d-inline-flex">
                                                                            <a class="p-1 tbl-action-btn edit"
                                                                                data-item="<?php echo e($howItWork); ?>"
                                                                                title="<?php echo e(__('Edit')); ?>">
                                                                                <span class="iconify"
                                                                                    data-icon="clarity:note-edit-solid"></span>
                                                                            </a>
                                                                            <a href="#"
                                                                                class="p-1 tbl-action-btn deleteItem"
                                                                                data-formid="delete_row_form_<?php echo e($howItWork->id); ?>"
                                                                                title="Delete"><span class="iconify"
                                                                                    data-icon="ep:delete-filled"></span></a>
                                                                            <form
                                                                                action="<?php echo e(route('admin.setting.how-it-work.destroy', [$howItWork->id])); ?>"
                                                                                method="post"
                                                                                id="delete_row_form_<?php echo e($howItWork->id); ?>">
                                                                                <?php echo e(method_field('DELETE')); ?>

                                                                                <input type="hidden" name="_token"
                                                                                    value="<?php echo e(csrf_token()); ?>">
                                                                            </form>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="addModalLabel"><?php echo e(__('Add How It Work')); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                            class="iconify" data-icon="akar-icons:cross"></span></button>
                </div>
                <form class="ajax" action="<?php echo e(route('admin.setting.how-it-work.store')); ?>" method="POST"
                    data-handler="getShowMessage">
                    <div class="modal-body">
                        <div class="modal-inner-form-box">
                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Title')); ?></label>
                                    <input type="text" name="title" class="form-control"
                                        placeholder="<?php echo e(__('Title')); ?>">
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Summery')); ?></label>
                                    <textarea name="summery" class="form-control" placeholder="<?php echo e(__('Summery')); ?>"></textarea>
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Content')); ?></label>
                                    <textarea name="content" class="form-control" placeholder="<?php echo e(__('Content')); ?>"></textarea>
                                    <small class="text-primary"><?php echo e(__('Separet by comma')); ?>(,)</small>
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Image')); ?></label>
                                    <input type="file" name="image" class="form-control">
                                </div>
                                <div class="col-md-12">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Status')); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1"><?php echo e(__('Active')); ?></option>
                                        <option value="0"><?php echo e(__('Deactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="<?php echo e(__('Back')); ?>"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3"
                            title="<?php echo e(__('Submit')); ?>"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="editModalLabel"><?php echo e(__('Edit Tickets Topic')); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                            class="iconify" data-icon="akar-icons:cross"></span></button>
                </div>
                <form class="ajax" action="<?php echo e(route('admin.setting.how-it-work.store')); ?>" method="POST"
                    data-handler="getShowMessage">
                    <div class="modal-body">
                        <input type="hidden" name="id">
                        <div class="modal-inner-form-box">
                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Title')); ?></label>
                                    <input type="text" name="title" class="form-control"
                                        placeholder="<?php echo e(__('Title')); ?>">
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Summery')); ?></label>
                                    <textarea name="summery" class="form-control" placeholder="<?php echo e(__('Summery')); ?>"></textarea>
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Content')); ?></label>
                                    <textarea name="content" class="form-control" placeholder="<?php echo e(__('Content')); ?>"></textarea>
                                    <small class="text-primary"><?php echo e(__('Separet by comma')); ?>(,)</small>
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Image')); ?></label>
                                    <input type="file" name="image" class="form-control">
                                </div>
                                <div class="col-md-12">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Status')); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1"><?php echo e(__('Active')); ?></option>
                                        <option value="0"><?php echo e(__('Deactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="<?php echo e(__('Back')); ?>"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3"
                            title="<?php echo e(__('Update')); ?>"><?php echo e(__('Update')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <?php echo $__env->make('admin.layouts.datatable-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('admin.layouts.datatable-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('backend/assets/js/pages/alldatatables.init.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/custom/howitwork.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/masumbd/project/ZaiwriteAI/resources/views/admin/setting/how-it-work.blade.php ENDPATH**/ ?>