@extends('admin.layouts.app')

@section('content')
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page Content Wrapper Start -->
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div
                                class="page-title-box d-sm-flex align-items-center justify-content-between border-bottom mb-20">
                                <div class="page-title-left">
                                    <h3 class="mb-sm-0">{{ __('Settings') }}</h3>
                                </div>

                                <div class="page-title-right">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"
                                                title="Dashboard">{{ __('Dashboard') }}</a></li>
                                        <li class="breadcrumb-item"><a href="#"
                                                title="Settings">{{ __('Settings') }}</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">{{ __('Currency') }}</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->
                    <!-- Settings Page Layout Wrap Area row Start -->
                    <div class="settings-page-layout-wrap position-relative">
                        <div class="row">
                            <!-- Account settings Left Side Start-->
                            @include('admin.setting.sidebar')
                            <!-- Account settings Left Side End-->
                            <!-- Account settings Area Right Side Start-->
                            <div class="col-md-12 col-lg-12 col-xl-8 col-xxl-9">
                                <div class="account-settings-rightside bg-off-white theme-border radius-4 p-25">
                                    <!-- Currency Settings Page Start -->
                                    <div class="currency-settings-page-area">
                                        <!-- Account Settings Content Box Start -->
                                        <div class="account-settings-content-box">
                                            <div class="account-settings-title border-bottom mb-20 pb-20">
                                                <div class="row align-items-center">
                                                    <div class="col-md-6">
                                                        <h4>{{ @$pageTitle }}</h4>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="property-details-right text-end">
                                                            <button type="button" class="theme-btn" data-bs-toggle="modal"
                                                                data-bs-target="#addCurrencyModal"
                                                                title="{{ __('Add Currency') }}">
                                                                Add Currency
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Currency List Table Area Start -->
                                            <div class="currency-list-table-area">
                                                <!-- datatable Start -->
                                                <div class="table-responsive bg-off-white theme-border radius-4 p-25">
                                                    <table id="datatableCurrencySettings"
                                                        class="table bg-off-white theme-border p-20 dt-responsive">
                                                        <thead>
                                                            <tr>
                                                                <th class="all">{{ __('Currency Code') }}</th>
                                                                <th class="all">{{ __('Symbol') }}</th>
                                                                <th class="desktop">{{ __('Currency Placement') }}</th>
                                                                <th class="desktop">{{ __('Action') }}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach ($currencies as $currency)
                                                                <tr>
                                                                    <td>{{ $currency->currency_code }}
                                                                        {{ $currency->current_currency == 'on' ? '(Current Currency)' : '' }}
                                                                    </td>
                                                                    <td>{{ $currency->symbol }}</td>
                                                                    <td>{{ ucwords($currency->currency_placement) }}</td>
                                                                    <td>
                                                                        <div class="tbl-action-btns d-inline-flex">
                                                                            <a class="p-1 tbl-action-btn edit"
                                                                                data-item="{{ $currency }}"
                                                                                data-updateurl="{{ route('admin.setting.currency.update', $currency->id) }}"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-target="#editCurrencyModal"
                                                                                title="Edit"><span class="iconify"
                                                                                    data-icon="clarity:note-edit-solid"></span>
                                                                            </a>
                                                                            <button class="p-1 tbl-action-btn deleteItem"
                                                                                data-formid="delete_row_form_{{ $currency->id }}">
                                                                                <span class="iconify"
                                                                                    data-icon="ep:delete-filled"></span>
                                                                            </button>
                                                                            <form
                                                                                action="{{ route('admin.setting.currency.destroy', [$currency->id]) }}"
                                                                                method="post"
                                                                                id="delete_row_form_{{ $currency->id }}">
                                                                                {{ method_field('DELETE') }}
                                                                                <input type="hidden" name="_token"
                                                                                    value="{{ csrf_token() }}">
                                                                            </form>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!-- datatable End -->
                                            </div>
                                            <!-- Currency List Table Area End -->
                                        </div>
                                        <!-- Account Settings Content Box End -->
                                    </div>
                                    <!-- Currency Settings Page End -->
                                </div>
                            </div>
                            <!-- Account settings Area Right Side End-->
                        </div>
                    </div>
                    <!-- Settings Page Layout Wrap Area row End -->
                </div>
                <!-- Page Content Wrapper End -->
            </div>
        </div>
    </div>

    <!-- Add Currency Modal Start -->
    <div class="modal fade" id="addCurrencyModal" tabindex="-1" aria-labelledby="addCurrencyModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="addCurrencyModalLabel">Add Currency</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                            class="iconify" data-icon="akar-icons:cross"></span>
                    </button>
                </div>
                <form action="{{ route('admin.setting.currency.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <!-- Modal Inner Form Box Start -->
                        <div class="modal-inner-form-box">

                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label class="label-text-title color-heading font-medium mb-2">Currency ISO Code</label>
                                    <input type="text" name="currency_code" class="form-control"
                                        placeholder="Enter currency ISO code">
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label class="label-text-title color-heading font-medium mb-2">Symbol</label>
                                    <input type="text" name="symbol" class="form-control" placeholder="Enter symbol">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label class="label-text-title color-heading font-medium mb-2">Currency
                                        Placement</label>
                                    <select name="currency_placement" class="form-select flex-shrink-0">
                                        <option value="before">before</option>
                                        <option value="after">after</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group custom-checkbox" title="Click to remember Sign In Info">
                                        <input type="checkbox" id="makeCurrentCurrency" name="current_currency">
                                        <label class="fw-normal" for="makeCurrentCurrency">Make Current Currency</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Modal Inner Form Box End -->
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="Back">Back</button>
                        <button type="submit" class="theme-btn me-3" title="Save">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Add Currency Modal End -->

    <!-- Edit Currency Modal Start -->
    <div class="modal fade edit_modal" id="editCurrencyModal" tabindex="-1" aria-labelledby="editCurrencyModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="editCurrencyModalLabel">Add Currency</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                            class="iconify" data-icon="akar-icons:cross"></span>
                    </button>
                </div>
                <form action="" id="updateEditModal" method="post">
                    @csrf
                    {{ method_field('PUT') }}
                    <div class="modal-body">
                        <!-- Modal Inner Form Box Start -->
                        <div class="modal-inner-form-box">

                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label class="label-text-title color-heading font-medium mb-2">Currency ISO
                                        Code</label>
                                    <input type="text" name="currency_code" class="form-control"
                                        placeholder="Enter currency ISO code">
                                </div>
                                <div class="col-md-12 mb-25">
                                    <label class="label-text-title color-heading font-medium mb-2">Symbol</label>
                                    <input type="text" name="symbol" class="form-control"
                                        placeholder="Enter symbol">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label class="label-text-title color-heading font-medium mb-2">Currency
                                        Placement</label>
                                    <select name="currency_placement" class="form-select flex-shrink-0">
                                        <option value="before">before</option>
                                        <option value="after">after</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group custom-checkbox" title="Click to remember Sign In Info">
                                        <input type="checkbox" id="updateMakeCurrentCurrency" name="current_currency">
                                        <label class="fw-normal" for="updateMakeCurrentCurrency">Make Current
                                            Currency</label>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- Modal Inner Form Box End -->
                    </div>

                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="Back">Back</button>
                        <button type="submit" class="theme-btn me-3" title="Save">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Edit Currency Modal End -->
@endsection

@push('style')
    @include('admin.layouts.datatable-style')
@endpush

@push('script')
    @include('admin.layouts.datatable-script')

    <!-- Datatable init js -->
    <script src="{{ asset('/') }}assets/js/pages/currency-datatables.init.js"></script>

    <script>
        $(function() {
            'use strict'
            $('.edit').on('click', function(e) {
                e.preventDefault();
                const modal = $('.edit_modal');
                modal.find('input[name=currency_code]').val($(this).data('item').currency_code)
                modal.find('input[name=symbol]').val($(this).data('item').symbol)
                modal.find('select[name=currency_placement]').val($(this).data('item').currency_placement)
                var current_currency = $(this).data('item').current_currency
                if (current_currency == 'on') {
                    modal.find('input[name=current_currency]').attr('checked', true)
                } else {
                    modal.find('input[name=current_currency]').attr('checked', false)
                }
                let route = $(this).data('updateurl');
                $('#updateEditModal').attr("action", route)
                modal.modal('show')
            })
        })
    </script>
@endpush
