<?php get_header(); ?>

<h1 id="site-title"><?php echo bloginfo('title') ?></h1>
<!-- Header Section -->
<?php get_template_part( 'template-parts/inner-pages/inner-pages', 'header' ); ?>
<!-- Header Section -->

<!-- Page Content Section -->
<section id="inner-page-container">
    <div id="page-top"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container p-0">
                    <div class="col-12 px-0">
                        <span class="section-title-line"></span>
                        <h1 class="section-title">خدمات</h1>
                        <h2 class="section-subtitle"><?php the_title() ?></h2>
                        <div id="content-box" class="p-3 p-lg-5">
                            <div class="row">
                                <div class="col-11 col-lg-3 px-0 mx-auto">
                                    <div class="side-panel">
                                        <ul class="pt-3 pr-3">
                                            <?php
                                            // the query
                                            $wpb_all_query = new WP_Query(array('post_type'=>'service', 'post_status'=>'publish', 'posts_per_page'=>-1)); ?>

                                            <?php if ( $wpb_all_query->have_posts() ) : ?>

                                                <!-- the loop -->
                                                <?php $counter = 1; ?>
                                                <?php $originalID = get_the_ID(); ?>
                                                <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                                                    <li class="<?php echo ($originalID == get_the_ID())? 'active':'' ?>"><a href="<?php the_permalink() ?>" class="hvr-icon-back"><i class="fa fa-chevron-circle-left hvr-icon"></i><?php the_title() ?></a></li>
                                                    <?php $counter++; ?>
                                                <?php endwhile; ?>
                                                <!-- end of the loop -->

                                                <?php wp_reset_postdata(); ?>

                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-9 pr-lg-5">
                                    <?php echo the_content() ?>
                                    <div id="keywords">
                                        <?php
                                        $post_tags = get_the_tags();
                                        if (!empty($post_tags))
                                            foreach ($post_tags as $tag)
                                                echo '<a href="'. get_tag_link($tag->term_id) . '" class="badge badge-info mx-1">'. $tag->name .'</a>';
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Page Content Section -->

<!-- Footer Section -->
<?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
<!-- /Footer Section -->

<?php get_footer(); ?>
