<?php get_header(); ?>

<h1 id="site-title"><?php echo bloginfo('title') ?></h1>
<!-- Header Section -->
<section id="header" class="inner-page">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 pt-3 pb-5" id="menu">
                <h1>منوی اصلی</h1>
                <!-- Menu -->
                <nav class="nav" id="mainNav">
                    <div class="container p-0">
                        <div class="logo d-block d-md-none">
                            <h2>دسترسی سریع</h2>
                        </div>
                        <?php if ( has_nav_menu( 'primary' ) ) : ?>
                            <div id="mainListDiv" class="main_list d-md-none">
                                <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
                            </div>
                            <nav id="mainListDiv" class="site-navigation d-none d-md-block" role="navigation">
                                <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
                            </nav>
                        <?php endif; ?>
                        <span class="navTrigger">
                            <i></i>
                            <i></i>
                            <i></i>
                        </span>
                    </div>
                </nav>
                <!-- /Menu -->
            </div>
        </div>
    </div>
</section>
<!-- Header Section -->

<!-- Page Content Section -->
<section id="inner-page-container">
    <div id="page-top"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container p-0">
                    <div class="col-12 px-0">
                        <span class="section-title-line"></span>
                        <h1 class="section-title">بلاگ</h1>
                        <h2 class="section-subtitle"><?php echo get_queried_object()->name; ?></h2>
                        <div id="content-box" class="p-3 p-lg-5">
                            <div class="row">

                                <?php get_template_part( 'template-parts/blog/blog', 'side-panel' ); ?>

                                <div class="col-12 col-lg-9 pr-lg-5" id="posts-list">
                                    <?php
                                    // the query
                                    $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>-1, 'cat'=>get_queried_object()->cat_ID, 'order' => 'DESC')); ?>

                                    <?php if ( $wpb_all_query->have_posts() ) : ?>

                                        <!-- the loop -->
                                        <?php $counter = 1; ?>
                                        <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>

                                            <div class="post-box">
                                                <div class="row">
                                                    <div class="col-12 col-md-5">
                                                        <a href="<?php the_permalink(); ?>"><img src="<?php echo get_the_post_thumbnail_url() ?>" width="100%" alt=""></a>
                                                    </div>
                                                    <div class="col-12 col-md-7 pt-3 pt-md-0">
                                                        <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                                        <div class="post-details">
                                                            <div class="d-inline"><i class="fa fa-calendar"></i> <?php echo get_the_date(); ?></div>
                                                            <div class="d-inline">| <i class="fa fa-user"></i> توسط <strong><a href=""><?php echo get_the_author_meta( 'display_name', $post->post_author ); ?></a></strong></div>
                                                            <div class="d-inline">| <i class="fa fa-eye"></i> <?php echo gt_get_post_view(); ?>بازدید</div>
                                                            <div class="d-inline">| <i class="fa fa-comment"></i> <?php comments_number() ?></div>
                                                        </div>
                                                        <?php the_excerpt() ?>
                                                        <a href="<?php the_permalink(); ?>" class="more-link hvr-icon-back">
                                                            ادامه مطلب <i class="fa fa-chevron-circle-left hvr-icon"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>

                                        <?php endwhile; ?>
                                        <!-- end of the loop -->

                                        <?php wp_reset_postdata(); ?>

                                    <?php else : ?>
                                        <p><?php _e( 'هیچ پستی ارسال نشده است!' ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Page Content Section -->

<!-- Footer Section -->
<?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
<!-- /Footer Section -->

<?php gt_set_post_view(); ?>
<?php get_footer(); ?>
