<?php
function radiance_register_theme_customize( $wp_customizer ){

    /* Theme Options */
    $wp_customizer->add_section(
        'radiance_base_section_options',
        array(
            'title'     => 'تنظیمات اصلی پوسته رادیانس',
            'priority'  => 160
        )
    );

    $wp_customizer->add_setting(
        'radiance_theme_color',
        array(
            'default'   =>  'colorful',
            'transport' =>  'refresh'
        )
    );

    $wp_customizer->add_control(
        'radiance_theme_color',
        array(
            'section'   =>  'radiance_base_section_options',
            'label'     =>  'انتخاب رنگی بندی پوسته',
            'type'      =>  'select',
            'choices' => array(
                'colorful' => 'رنگ بندی آبی',
                'dark' => 'رنگ بندی سبز',
                'light' => 'رنگ بندی بنفش',
            )
        )
    );
    /* /Theme Options */

    /* Homepage Panel */
    $wp_customizer->add_panel( 'homepage_navigation_panel',
        array(
            'title' => __( 'مدیریت صفحه نخست اختصاصی' ),
            'description' => esc_html__( 'مدیریت محتوا و بخش های صفحه نخست اختصاصی' ), // Include html tags such as

            'priority' => 170, // Not typically needed. Default is 160
            'capability' => 'edit_theme_options', // Not typically needed. Default is edit_theme_options
            'theme_supports' => '', // Rarely needed
            'active_callback' => '', // Rarely needed
        )
    );

    /* Heading Section */
    $wp_customizer->add_section(
        'radiance_heading_section_options',
        array(
            'panel'     => 'homepage_navigation_panel',
            'title'     => 'بخش هدر صفحه اصلی',
            'priority'  => '400'
        )
    );

    $wp_customizer->add_setting(
        'radiance_heading_headline_text',
        array(
            'default'   => 'من',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_heading_headline_text',
        array(
            'section'   => 'radiance_heading_section_options',
            'label'     => 'متن سطر اول',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_heading_name_text',
        array(
            'default'   => 'مصطفی<br>کلانتری',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_heading_name_text',
        array(
            'section'       => 'radiance_heading_section_options',
            'label'         => 'نام شما',
            'type'          => 'text',
            'input_attrs'   => array (
                'maxlength' =>  17
            )
        )
    );

    $wp_customizer->add_setting(
        'radiance_heading_subline_text',
        array(
            'default'   => 'یک فریلنسر هستم',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_heading_subline_text',
        array(
            'section'   => 'radiance_heading_section_options',
            'label'     => 'متن سطر آخر',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_heading_image',
        array(
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        new WP_Customize_Image_Control(
            $wp_customizer,
            'radiance_heading_image',
            array(
                'section'   => 'radiance_heading_section_options',
                'label'     => 'انتخاب تصویر (700*700 پیکسل)',
                'settings'      => 'radiance_heading_image'
            )
        )
    );

    $wp_customizer->add_setting(
        'radiance_heading_social_links_active',
        array(
            'default'   => true,
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_heading_social_links_active',
        array(
            'section'   => 'radiance_heading_section_options',
            'label'     => 'نمایش شبکه های اجتماعی',
            'type'      => 'checkbox'
        )
    );
    /* /Heading Section */

    /* About Section */
    $wp_customizer->add_section(
        'radiance_about_section_options',
        array(
            'panel'     => 'homepage_navigation_panel',
            'title'     => 'بخش معرفی',
            'priority'  => '500'
        )
    );

    $wp_customizer->add_setting(
        'radiance_about_title',
        array(
            'default'   => 'درباره من',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_about_title',
        array(
            'section'   => 'radiance_about_section_options',
            'label'     => 'عنوان بخش',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_about_text',
        array(
            'default'   => '',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_about_text',
        array(
            'section'       => 'radiance_about_section_options',
            'label'         => 'متن معرفی',
            'type'          => 'textarea',
        )
    );

    $wp_customizer->add_setting(
        'radiance_about_image',
        array(
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        new WP_Customize_Image_Control(
            $wp_customizer,
            'radiance_about_image',
            array(
                'section'   => 'radiance_about_section_options',
                'label'     => 'تصویر کناری (450*350 پیکسل)',
                'settings'      => 'radiance_about_image'
            )
        )
    );
    /* /About Section */

    /* Specialists Section */
    $wp_customizer->add_section(
        'radiance_specialists_section_options',
        array(
            'panel'     => 'homepage_navigation_panel',
            'title'     => 'بخش تخصص ها',
            'priority'  => '600'
        )
    );

    $wp_customizer->add_setting(
        'radiance_specialists_section_active',
        array(
            'default'   => true,
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_specialists_section_active',
        array(
            'section'   => 'radiance_specialists_section_options',
            'label'     => 'نمایش بخش تخصص ها',
            'type'      => 'checkbox'
        )
    );

    $wp_customizer->add_setting(
        'radiance_specialists_title',
        array(
            'default'   => 'تخصص های من',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_specialists_title',
        array(
            'section'   => 'radiance_specialists_section_options',
            'label'     => 'عنوان بخش',
            'type'      => 'text'
        )
    );

    for($i = 1; $i <= 8; $i++){
        $wp_customizer->add_setting(
            'radiance_specialists_item'.$i.'_title',
            array(
                'default'   => '0',
                'transport' => 'refresh'
            )
        );
        $wp_customizer->add_control(
            'radiance_specialists_item'.$i.'_title',
            array(
                'section'   => 'radiance_specialists_section_options',
                'label'     => 'عنوان تخصص '.$i,
                'type'      => 'text',
                'input_attrs'   => array (
                    'maxlength' =>  40
                )
            )
        );

        $wp_customizer->add_setting(
            'radiance_specialists_item'.$i.'_value',
            array(
                'default'   => '0',
                'transport' => 'refresh'
            )
        );
        $wp_customizer->add_control(
            'radiance_specialists_item'.$i.'_value',
            array(
                'section'       => 'radiance_specialists_section_options',
                'label'         => 'میزان تسلط (1 تا 100)',
                'type'          => 'number',
                'input_attrs' => array(
                    'min'   => 1,
                    'max'   => 100)
            )
        );
    }

    $wp_customizer->add_setting(
        'radiance_specialists_image',
        array(
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        new WP_Customize_Image_Control(
            $wp_customizer,
            'radiance_specialists_image',
            array(
                'section'   => 'radiance_specialists_section_options',
                'label'     => 'تصویر کناری (390*540 پیکسل)',
                'settings'      => 'radiance_specialists_image'
            )
        )
    );
    /* /Specialists Section */

    /* Services Section */
    $wp_customizer->add_section(
        'radiance_services_section_options',
        array(
            'panel'     => 'homepage_navigation_panel',
            'title'     => 'بخش خدمات',
            'priority'  => '700'
        )
    );
    $wp_customizer->add_setting(
        'radiance_services_section_active',
        array(
            'default'   => true,
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_services_section_active',
        array(
            'section'   => 'radiance_services_section_options',
            'label'     => 'نمایش بخش خدمات',
            'type'      => 'checkbox'
        )
    );

    $wp_customizer->add_setting(
        'radiance_services_title',
        array(
            'default'   => 'خدمات من',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_services_title',
        array(
            'section'   => 'radiance_services_section_options',
            'label'     => 'عنوان بخش',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_services_image',
        array(
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        new WP_Customize_Image_Control(
            $wp_customizer,
            'radiance_services_image',
            array(
                'section'   => 'radiance_services_section_options',
                'label'     => 'انتخاب تصویر (450*450 پیکسل)',
                'settings'      => 'radiance_services_image'
            )
        )
    );
    /* /Services Section */

    /* Resume Section */
    $wp_customizer->add_section(
        'radiance_resume_section_options',
        array(
            'panel'     => 'homepage_navigation_panel',
            'title'     => 'بخش نمونه کار ها',
            'priority'  => '800'
        )
    );
    $wp_customizer->add_setting(
        'radiance_resume_section_active',
        array(
            'default'   => true,
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_resume_section_active',
        array(
            'section'   => 'radiance_resume_section_options',
            'label'     => 'نمایش بخش نمونه کار ها',
            'type'      => 'checkbox'
        )
    );

    $wp_customizer->add_setting(
        'radiance_resume_title',
        array(
            'default'   => 'نمونه کارها',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_resume_title',
        array(
            'section'   => 'radiance_resume_section_options',
            'label'     => 'عنوان بخش',
            'type'      => 'text'
        )
    );
    /* /Resume Section */

    /* Blog Section */
    $wp_customizer->add_section(
        'radiance_blog_section_options',
        array(
            'panel'     => 'homepage_navigation_panel',
            'title'     => 'بخش بلاگ',
            'priority'  => '900'
        )
    );
    $wp_customizer->add_setting(
        'radiance_blog_section_active',
        array(
            'default'   => true,
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_blog_section_active',
        array(
            'section'   => 'radiance_blog_section_options',
            'label'     => 'نمایش بخش بلاگ',
            'type'      => 'checkbox'
        )
    );

    $wp_customizer->add_setting(
        'radiance_blog_title',
        array(
            'default'   => 'آخرین مطالب',
            'transport' => 'postMessage'
        )
    );
    $wp_customizer->add_control(
        'radiance_blog_title',
        array(
            'section'   => 'radiance_blog_section_options',
            'label'     => 'عنوان بخش',
            'type'      => 'text'
        )
    );
    /* /Blog Section */

    /* /Homepage Panel */

    /* Social Links Section */
    $wp_customizer->add_section(
        'radiance_social_links_options',
        array(
            'title'     => 'شبکه های اجتماعی',
            'priority'  => 170
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_instagram_link',
        array(
            'default'   => 'instagram.com/webrubik_com',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_instagram_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'اینستاگرام',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_linkedin_link',
        array(
            'default'   => 'linkedin.com/in/webrubik-dot-com-873a48185',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_linkedin_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'لینکدین',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_telegram_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_telegram_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'تلگرام',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_twitter_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_twitter_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'توئیتر',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_facebook_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_facebook_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'فیس بوک',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_github_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_github_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'گیت هاب',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_aparat_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_aparat_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'آپارات',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_youtube_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_youtube_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'یوتیوب',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_pinterest_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_pinterest_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'پینترست',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_behance_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_behance_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'بیهنس',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_dribbble_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_dribbble_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'دریبل',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_vimeo_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_vimeo_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'ویمئو',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_flickr_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_flickr_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'فلیکر',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_skype_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_skype_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'اسکایپ',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_snapchat_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_snapchat_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'اسنپ چت',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_foursquare_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_foursquare_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'Foursquare',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_tumblr_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_tumblr_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'Tumblr',
            'type'      => 'text'
        )
    );

    $wp_customizer->add_setting(
        'radiance_social_yelp_link',
        array(
            'default'   => '',
            'transport' => 'refresh'
        )
    );
    $wp_customizer->add_control(
        'radiance_social_yelp_link',
        array(
            'section'   => 'radiance_social_links_options',
            'label'     => 'Yelp',
            'type'      => 'text'
        )
    );
    /* /Social Links Section */

}
add_action( 'customize_register', 'radiance_register_theme_customize');