<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Radiance
 * @since 1.0.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
*/
if ( post_password_required() ) {
	return;
}

$discussion = radiance_get_discussion_data();
?>

<div id="comments" class="<?php echo comments_open() ? 'comments-area' : 'comments-area comments-closed'; ?>">
	<div class="<?php echo $discussion->responses > 0 ? 'comments-title-wrap' : 'comments-title-wrap no-responses'; ?>">
		<h4 class="comments-title">
		<?php
		if ( comments_open() ) {
			if ( have_comments() ) {
				_e( 'نظرات کاربران', 'radiance' );
			} else {
				_e( 'نظر خود را ارسال کنید', 'radiance' );
			}
		} else {
			if ( '1' == $discussion->responses ) {
				/* translators: %s: Post title. */
				printf( _x( 'One reply on &ldquo;%s&rdquo;', 'comments title', 'radiance' ), get_the_title() );
			} else {
				printf(
					/* translators: 1: Number of comments, 2: Post title. */
					_nx(
						'%1$s reply on &ldquo;%2$s&rdquo;',
						'%1$s replies on &ldquo;%2$s&rdquo;',
						$discussion->responses,
						'comments title',
						'radiance'
					),
					number_format_i18n( $discussion->responses ),
					get_the_title()
				);
			}
		}
		?>
		</h4><!-- .comments-title -->
	</div><!-- .comments-title-flex -->
	<?php
	if ( have_comments() ) :

		// Show comment form at top if showing newest comments at the top.
		if ( comments_open() ) {
			radiance_comment_form( 'desc' );
		}

		?>
		<div class="comment-list">
			<?php
			wp_list_comments(
				array(
					'walker'      => new Radiance_Walker_Comment(),
					'avatar_size' => radiance_get_avatar_size(),
					'short_ping'  => true,
					'style'       => 'div'
				)
			);
			?>
		</div><!-- .comment-list -->
		<?php

		// Show comment navigation
		if ( have_comments() ) :
			$prev_icon     = radiance_get_icon_svg( 'chevron_left', 22 );
			$next_icon     = radiance_get_icon_svg( 'chevron_right', 22 );
			$comments_text = __( 'Comments', 'radiance' );
			the_comments_navigation(
				array(
					'prev_text' => sprintf( '%s <span class="nav-prev-text"><span class="primary-text">%s</span> <span class="secondary-text">%s</span></span>', $prev_icon, __( 'Previous', 'radiance' ), __( 'Comments', 'radiance' ) ),
					'next_text' => sprintf( '<span class="nav-next-text"><span class="primary-text">%s</span> <span class="secondary-text">%s</span></span> %s', __( 'Next', 'radiance' ), __( 'Comments', 'radiance' ), $next_icon ),
				)
			);
		endif;

		// Show comment form at bottom if showing newest comments at the bottom.
		if ( comments_open() && 'asc' === strtolower( get_option( 'comment_order', 'asc' ) ) ) :
			?>
            <div class="row">
                <div class="col-12">
                    <div class="comment-form-flex pt-5" id="respond">
                        <h3 class="comments-title" aria-hidden="true"><?php _e( 'نظر خود را ارسال کنید', 'radiance' ); ?></h3>
                        <?php radiance_comment_form( 'asc' ); ?>
                    </div>
                </div>
            </div>
			<?php
		endif;

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments">
				<?php _e( 'نظرات این پست بسته شده است.', 'radiance' ); ?>
			</p>
			<?php
		endif;

	else :

		// Show comment form.
		radiance_comment_form( true );

	endif; // if have_comments();
	?>
</div><!-- #comments -->
