

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <div class="row">
                        <div class="col-12">
                            <div
                                class="page-title-box d-sm-flex align-items-center justify-content-between border-bottom mb-20">
                                <div class="page-title-left">
                                    <h3 class="mb-sm-0"><?php echo e(__(@$pageTitle)); ?></h3>
                                </div>
                                <div class="page-title-right">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"
                                                title="Dashboard"><?php echo e(__('Dashboard')); ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__(@$pageTitle)); ?></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="settings-page-layout-wrap position-relative">
                        <div class="row">
                            <?php echo $__env->make('admin.setting.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="col-md-12 col-lg-12 col-xl-8 col-xxl-9">
                                <div class="account-settings-rightside bg-off-white theme-border radius-4 p-25">
                                    <div class="color-settings-page-area">
                                        <div class="account-settings-content-box">
                                            <div class="account-settings-title border-bottom mb-20 pb-20">
                                                <div class="row align-items-center">
                                                    <div class="col-md-6">
                                                        <h4><?php echo e(__(@$pageTitle)); ?></h4>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="information-table-area">
                                                <div class="table-responsive bg-off-white theme-border radius-4 p-25">
                                                    <table id="allDataTable"
                                                        class="table bg-off-white theme-border dt-responsive">
                                                        <thead>
                                                            <tr>
                                                                <th><?php echo e(__('SL')); ?></th>
                                                                <th><?php echo e(__('Image')); ?></th>
                                                                <th><?php echo e(__('Title')); ?></th>
                                                                <th><?php echo e(__('Slug')); ?></th>
                                                                <th><?php echo e(__('Status')); ?></th>
                                                                <th><?php echo e(__('Mode')); ?></th>
                                                                <th><?php echo e(__('Action')); ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td><?php echo e($loop->iteration); ?></td>
                                                                    <td>
                                                                        <div class="upload-profile-photo-box mb-25">
                                                                            <div
                                                                                class="profile-user position-relative d-inline-block">
                                                                                <img src="<?php echo e($gateway->icon); ?>"
                                                                                    class="rounded-circle avatar-xl maintainer-user-profile-image image"
                                                                                    alt="">
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                    <td><?php echo e($gateway->title); ?></td>
                                                                    <td><?php echo e($gateway->slug); ?></td>
                                                                    <td>
                                                                        <?php if($gateway->status == ACTIVE): ?>
                                                                            <div
                                                                                class="status-btn status-btn-green font-13 radius-4">
                                                                                <?php echo e(__('Active')); ?></div>
                                                                        <?php else: ?>
                                                                            <div
                                                                                class="status-btn status-btn-orange font-13 radius-4">
                                                                                <?php echo e(__('Deactive')); ?></div>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                        <?php if($gateway->mode == GATEWAY_MODE_LIVE): ?>
                                                                            <div
                                                                                class="status-btn status-btn-green font-13 radius-4">
                                                                                <?php echo e(__('Live')); ?></div>
                                                                        <?php else: ?>
                                                                            <div
                                                                                class="status-btn status-btn-orange font-13 radius-4">
                                                                                <?php echo e(__('Sandbox')); ?></div>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                        <button type="button"
                                                                            class="p-1 tbl-action-btn edit"
                                                                            data-id="<?php echo e($gateway->id); ?>"
                                                                            title="<?php echo e(__('Edit')); ?>"><span class="iconify"
                                                                                data-icon="clarity:note-edit-solid"></span>
                                                                        </button>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="editModalLabel"><?php echo e(__('Edit Gateway')); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                            class="iconify" data-icon="akar-icons:cross"></span></button>
                </div>
                <form class="ajax" action="<?php echo e(route('admin.setting.gateway.store')); ?>" method="POST"
                    data-handler="getShowMessage">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" id="id" required>
                    <div class="modal-body">
                        <h4 class="mb-15"><?php echo e(__('Gateway')); ?></h4>
                        <div class="modal-inner-form-box bg-off-white theme-border radius-4 p-20">
                            <div class="row">
                                <div class="upload-profile-photo-box mb-25">
                                    <div class="profile-user position-relative d-inline-block">
                                        <img src=""
                                            class="rounded-circle avatar-xl maintainer-user-profile-image image"
                                            alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Title')); ?></label>
                                    <input type="text" class="form-control title" readonly>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Slug')); ?></label>
                                    <input type="text" name="slug" class="form-control slug" readonly>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Status')); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="0"><?php echo e(__('Deactive')); ?></option>
                                        <option value="1"><?php echo e(__('Active')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-25 mode-div">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Mode')); ?></label>
                                    <select name="mode" id="mode" class="form-control">
                                        <option value="1"><?php echo e(__('Live')); ?></option>
                                        <option value="2"><?php echo e(__('Sandbox')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="bank-div">
                                <div class="bank-div-append">

                                </div>
                                <div class="row mb-20">
                                    <div class="col-12 text-end"><button type="button" class="green-color add-bank" title="<?php echo e(__('Add Bank')); ?>"><span class="iconify" data-icon="material-symbols:add"></span> <?php echo e(__('Add Bank')); ?></button></div>
                                </div>
                            </div>

                            <div class="row url-div">
                                <div class="col-md-12 mb-25 gateway-input" id="gateway-url">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Url')); ?>/<?php echo e(__('Hash')); ?></label>
                                    <input class="form-control" type="text" name="url">
                                </div>
                            </div>
                            <div class="row key-secret-div">
                                <div class="col-md-12 mb-25 gateway-input" id="gateway-key">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Key')); ?></label>
                                    <input class="form-control" type="text" name="key">
                                    <small
                                        class="d-none small"><?php echo e(__('Client id, Public Key, Key, Store id, Api Key')); ?></small>
                                </div>
                                <div class="col-md-12 mb-25 gateway-input" id="gateway-secret">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Secret')); ?></label>
                                    <input class="form-control" type="text" name="secret">
                                    <small
                                        class="d-none small"><?php echo e(__('Client Secret, Secret, Store Password, Auth Token')); ?></small>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Conversion Rate')); ?>

                                        <button type="button" class="add-currency edit-btn"><span class="iconify" data-icon="material-symbols:add-rounded"></span></button>
                                    </label>
                                    <div id="currencyConversionRateSection"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="<?php echo e(__('Back')); ?>"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3"
                            title="<?php echo e(__('Submit')); ?>"><?php echo e(__('Update')); ?></button>
                    </div>
                </form>

            </div>
        </div>
    </div>
    <input type="hidden" id="getInfoRoute" value="<?php echo e(route('admin.setting.gateway.get.info')); ?>">
    <input type="hidden" id="getCurrencySymbol" value="<?php echo e(getCurrencySymbol()); ?>">
    <input type="hidden" id="allCurrency" value="<?php echo e(json_encode(getCurrency())); ?>">
    <input type="hidden" id="gatewaySettings" value="<?php echo e(getOption('gateway_settings')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <?php echo $__env->make('admin.layouts.datatable-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('admin.layouts.datatable-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('backend/assets/js/pages/alldatatables.init.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/custom/gateway.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/miladali/public_html/forums/resources/views/admin/setting/gateway.blade.php ENDPATH**/ ?>