

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <div class="row">
                        <div class="col-12">
                            <div
                                class="page-title-box d-sm-flex align-items-center justify-content-between border-bottom mb-20">
                                <div class="page-title-left">
                                    <h3 class="mb-sm-0"><?php echo e(__('Settings')); ?></h3>
                                </div>
                                <div class="page-title-right">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"
                                                title="<?php echo e(__('Dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__(@$pageTitle)); ?></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="settings-page-layout-wrap position-relative">
                        <div class="row">
                            <?php echo $__env->make('admin.setting.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="col-md-12 col-lg-12 col-xl-8 col-xxl-9">
                                <div class="account-settings-rightside bg-off-white theme-border radius-4 p-25">
                                    <div class="language-settings-page-area">
                                        <div class="account-settings-content-box">
                                            <div class="account-settings-title border-bottom mb-20 pb-20">
                                                <div class="row align-items-center">
                                                    <div class="col-md-6">
                                                        <h4> <?php echo e(__('Translate Your Language')); ?> (English =>
                                                            <?php echo e($language->name); ?> )</h4>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="property-details-right text-end">
                                                            <button type="button" class="theme-btn" data-bs-toggle="modal"
                                                                data-bs-target="#importModal"
                                                                title="<?php echo e(__('Import Keywords')); ?>">
                                                                <?php echo e(__('Import Keywords')); ?>

                                                            </button>
                                                            <button type="button" class="theme-btn-green addmore"> <i
                                                                    class="fa fa-plus"></i>
                                                                <?php echo e(__('Add More')); ?></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="language-list-table-area">
                                                <div class="table-responsive bg-off-white theme-border radius-4 p-25">
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <table
                                                                class="table bg-off-white theme-border p-20 dt-responsive">
                                                                <thead>
                                                                    <tr>
                                                                        <th><?php echo e(__('Key')); ?></th>
                                                                        <th><?php echo e(__('Value')); ?></th>
                                                                        <th class="text-end"><?php echo e(__('Action')); ?></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="append">
                                                                    <?php $__currentLoopData = $translators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <tr>
                                                                            <td>
                                                                                <textarea type="text" class="key form-control" readonly required><?php echo $key; ?></textarea>
                                                                            </td>
                                                                            <td>
                                                                                <input type="hidden" value="0"
                                                                                    class="is_new">
                                                                                <textarea type="text" class="val form-control" required><?php echo $value; ?></textarea>
                                                                            </td>
                                                                            <td class="text-end">
                                                                                <button type="button"
                                                                                    class="updateLangItem theme-btn"
                                                                                    disabled><?php echo e(__('Update')); ?></button>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Modal section start -->
    <div class="modal fade" id="importModal" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form class="ajax" action="<?php echo e(route('admin.language.import')); ?>" method="POST"
                    data-handler="getShowMessage">
                    <input type="hidden" name="current" value="<?php echo e($language->code); ?>">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Import Language')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                                class="iconify" data-icon="akar-icons:cross"></span></button>
                    </div>
                    <div class="modal-body">
                        <div class="modal-inner-form-box">
                            <div class="row">
                                <div class="mb-30">
                                    <span
                                        class="text-danger text-center"><?php echo e(__('Note: If you import keywords, your current keywords will be deleted and replaced by the imported keywords.')); ?></span>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label for="status" class="label-text-title color-heading font-medium mb-2">
                                        <?php echo e(__('Language')); ?> </label>
                                    <select name="import" class="form-select flex-shrink-0 export" id="inputGroupSelect02">
                                        <option value=""> <?php echo e(__('Select Option')); ?> </option>
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($lang->code); ?>"><?php echo e(__($lang->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="Back"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3" title="Submit"><?php echo e(__('Import')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <input type="hidden" id="updateLangItemRoute" value="<?php echo e(route('admin.language.update.translate', [$language->id])); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('backend/assets/js/custom/language.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khavarii/test.khavarii.com/resources/views/admin/language/translate.blade.php ENDPATH**/ ?>