<header id="page-topbar">
    <div class="navbar-header">
        <div class="d-flex">
            <div class="navbar-brand-box">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="<?php echo e(getSettingImage('app_logo_black')); ?>" alt="logo-sm-light">
                    </span>
                    <span class="logo-lg">
                        <img src="<?php echo e(getSettingImage('app_logo_black')); ?>" alt="logo-light">
                    </span>
                </a>
            </div>
            <button type="button" class="btn-sm px-3 font-24 header-item" id="vertical-menu-btn">
                <i class="ri-indent-decrease"></i>
            </button>
        </div>

        <div class="d-flex">
            <div class="dropdown d-inline-block">
                <button type="button" class="header-item noti-icon" id="page-header-languages-dropdown"
                    data-bs-toggle="dropdown" aria-expanded="false">
                    <img src="<?php echo e(asset(selectedLanguage()->icon)); ?>" alt="<?php echo e(selectedLanguage()->name ?? 'English'); ?>"
                        title="<?php echo e(selectedLanguage()->name ?? 'English'); ?>" class="rounded-circle avatar-xs fit-image">
                </button>

                <div class="dropdown-menu <?php echo e(selectedLanguage()->rtl == 1 ? 'dropdown-menu-start' : 'dropdown-menu-end'); ?>"
                    aria-labelledby="page-header-languages-dropdown">
                    <div>
                        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('local', $language->code)); ?>" class="dropdown-item" title="EN">
                                <div class="d-flex">
                                    <img src="<?php echo e($language->icon); ?>" class="me-3 rounded-circle avatar-xs"
                                        alt="user-pic">
                                    <div class="flex-1"><?php echo e($language->name); ?></div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="dropdown d-inline-block">
                <button type="button" class="header-item noti-icon" id="page-header-notifications-dropdown"
                    data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ri-notification-2-fill"></i>
                    <span class="noti-dot pulse"></span>
                </button>
                <div class="dropdown-menu dropdown-menu-lg <?php echo e(selectedLanguage()->rtl == 1 ? 'dropdown-menu-start' : 'dropdown-menu-end'); ?> p-0"
                    aria-labelledby="page-header-notifications-dropdown">
                    <div class="p-3">
                        <div class="row align-items-center">
                            <div class="col">
                                <h5 class="m-0 text-start"><?php echo e(__('Notifications')); ?></h5>
                            </div>
                            <div class="col-auto">
                            </div>
                        </div>
                    </div>
                    <div data-simplebar>
                        <?php $__currentLoopData = getNotification(auth()->id()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('notification.status', $notification->id)); ?>" class="notification-item">
                                <div class="d-flex">
                                    <img src="<?php echo e(getFileUrl($notification->folder_name, $notification->file_name)); ?>"
                                        class="me-3 rounded-circle avatar-xs" alt="user-pic">

                                    <div class="flex-1">
                                        <h6 class="mb-1"><?php echo e($notification->first_name); ?></h6>
                                        <div class="">
                                            <p class="mb-1"><?php echo e($notification->title); ?></p>
                                            <p class="mb-0 font-12"><i class="mdi mdi-clock-outline"></i>
                                                <?php echo e($notification->created_at->diffForHumans()); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="dropdown d-inline-block user-dropdown">
                <button type="button" class="header-item" id="page-header-user-dropdown" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <img class="rounded-circle avatar-xs fit-image header-profile-user"
                        src="<?php echo e(auth()->user()->image); ?>">
                    <span class="d-none d-xl-inline-block ms-1 font-medium"><?php echo e(auth()->user()->name); ?></span>
                    <i class="mdi mdi-chevron-down d-xl-inline-block"></i>
                </button>
                <div class="dropdown-menu <?php echo e(selectedLanguage()->rtl == 1 ? 'dropdown-menu-start' : 'dropdown-menu-end'); ?>"
                    aria-labelledby="page-header-user-dropdown">
                    <a class="dropdown-item" href="<?php echo e(route('admin.profile')); ?>"><i
                            class="ri-user-line align-middle me-1"></i> <?php echo e(__('Profile')); ?></a>
                    <?php if(auth()->user()->role == USER_ROLE_ADMIN): ?>
                        <a class="dropdown-item" href="<?php echo e(route('admin.setting.general-setting')); ?>"><i
                                class="ri-settings-2-line align-middle me-1"></i> <?php echo e(__('Settings')); ?></a>
                    <?php endif; ?>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"><i
                            class="ri-shut-down-line align-middle me-1"></i> <?php echo e(__('Logout')); ?></a>
                </div>
            </div>
        </div>
    </div>
</header>
<?php /**PATH /home/miladali/public_html/forums/resources/views/admin/layouts/header.blade.php ENDPATH**/ ?>