<?php $__env->startSection('content'); ?>
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-4">
            <a href="#" class="app-brand-link gap-2 d-flex align-items-center justify-content-center my-3">
                <img src="/assets/admin/img/branding/logo.png" width="100px">
            </a>
            <!-- Register -->
            <div class="card" id="login">
                <div class="card">

                    <h5 class="card-header heading-color text-center">فرم ثبت سفارش</h5>
                    <div class="card-body">
                        <form id="order-submit" action="<?php echo e(route('orders.store')); ?>"
                              class="row g-3 mb-3"
                              method="post" novalidate="novalidate" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('post'); ?>
                            <!-- Account Details -->

                            <div class="col-12">
                                <h6 class="fw-normal">1. اطلاعات فردی و آدرس</h6>
                                <hr class="mt-0 mb-2">
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="name">نام </label>
                                <input type="text" id="name" class="form-control"
                                       placeholder="لطفا نام خود را وارد کنید"
                                       value="<?php echo e(old('name')); ?>"
                                       name="name" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="lastname">نام خانوادگی </label>
                                <input type="text" id="lastname" class="form-control"
                                       placeholder="لطفا نام خانوادگی خود را وارد کنید"
                                       value="<?php echo e(old('lastname')); ?>"
                                       name="lastname" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="phone">موبایل</label>
                                <input type="text" id="phone" class="form-control"
                                       placeholder="لطفا موبایل خود را وارد کنید"
                                       value="<?php echo e(old('phone')); ?>"
                                       name="phone" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="instagram_id">آیدی اینستاگرام</label>
                                <input type="text" id="instagram_id" class="form-control"
                                       value="<?php echo e(old('instagram_id')); ?>"
                                       placeholder="لطفا آیدی اینستاگرام خود را وارد کنید"
                                       name="instagram_id" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="postal_code">کد پستی</label>
                                <input type="text" id="postal_code" class="form-control"
                                       placeholder="لطفا کد پستی خود را وارد کنید"
                                       value="<?php echo e(old('postal_code')); ?>"
                                       name="postal_code" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="address">آدرس</label>
                                <textarea class="form-control" placeholder="لطفا آدرس خود را وارد کنید" name="address"
                                          id="address" cols="30" rows="5"><?php echo e(old('address')); ?></textarea>
                            </div>


                            <!-- Personal Info -->

                            <div class="col-12">
                                <h6 class="mt-4 fw-normal">2. انتخاب محصول</h6>
                                <hr class="mt-0 mb-2">
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="address">انتخاب محصول (امکان انتخاب چند محصول همزمان وجود دارد)</label>
                                <select id="products" class="select2 form-select"
                                        name="products[]" multiple="multiple" required>
                                    <?php $__currentLoopData = \Modules\Product\Models\Product::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($product->id); ?>" <?php echo e(in_array($product->id, old('products') ?: []) ? 'selected' : ''); ?>><?php echo e($product->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-12">
                                <h6 class="mt-4 fw-normal">3. آپلود فیش</h6>
                                <hr class="mt-0 mb-2">
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="address">آپلود فیش پرداختی</label>
                                <input type="file" name="payment_image" id="payment_image" value="<?php echo e(old('payment_image')); ?>" class="form-control ">
                            </div>


                            <!-- Choose Your Plan -->
                            <button type="submit" class="btn btn-primary">ثبت سفارش</button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /Register -->

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <script src="/assets/admin/vendor/libs/select2/select2.js"></script>
    <script src="/assets/front/order.js"></script>
    <script>
        $('.select2').select2();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/farshadrajabzadeh/Herd/clodiashop/Modules/Order/resources/views/front/index.blade.php ENDPATH**/ ?>