const createNewItem = document.querySelector('#createNewItem');


if (createNewItem) {
    const fv = FormValidation.formValidation(createNewItem, {
        fields: {
            created_at: {
                validators: {
                    notEmpty: {
                        message: 'لطفا تاریخ را وارد کنید'
                    }
                }
            },
            description: {
                validators: {
                    notEmpty: {
                        message: 'لطفا توضیحات را وارد کنید'
                    }
                }
            },
        },
        plugins: {
            trigger: new FormValidation.plugins.Trigger(),
            bootstrap5: new FormValidation.plugins.Bootstrap5({
                eleValidClass: '',
            }),
            autoFocus: new FormValidation.plugins.AutoFocus()
        },
        init: instance => {
            instance.on('plugins.message.placed', function (e) {
                if (e.element.parentElement.classList.contains('input-group')) {
                    e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
                }
            });
        }
    });
}

$("#task_date").pDatepicker({
    "inline": false,
    "format": "YYYY/MM/DD",
    "viewMode": "day",
    "initialValue": false,
    "initialValueType": 'persian',
    "minDate": -1539487544000,
    "maxDate": new Date().getTime(),
    "autoClose": true,
    "position": "auto",
    "altField": "#txtBirthday",
    "onlyTimePicker": false,
    "onlySelectOnDate": true,
    "calendarType": "persian",
    "inputDelay": 800,
    "observer": true,
    "calendar": {
        "persian": {
            "locale": "fa",
            "showHint": true,
            "leapYearMode": "algorithmic"
        }
    },
    "navigator": {
        "enabled": true,
        "scroll": {
            "enabled": true
        },
        "text": {
            "btnNextText": "<",
            "btnPrevText": ">"
        }
    },
    "toolbox": {
        "enabled": true,
        "calendarSwitch": {
            "enabled": false,
            "format": "MMMM"
        },
        "todayButton": {
            "enabled": true,
            "text": {
                "fa": "امروز",
                "en": "Today"
            }
        },
        "submitButton": {
            "enabled": true,
            "text": {
                "fa": "بستن",
                "en": "Submit"
            }
        },
        "text": {
            "btnToday": "امروز"
        }
    },
    "timePicker": {
        "enabled": false,
        "step": 1,
        "hour": {
            "enabled": true,
            "step": null
        },
        "minute": {
            "enabled": true,
            "step": null
        },
        "second": {
            "enabled": false,
            "step": null
        },
        "meridian": {
            "enabled": false
        }
    },
    "dayPicker": {
        "enabled": true,
        "titleFormat": "YYYY MMMM"
    },
    "monthPicker": {
        "enabled": true,
        "titleFormat": "YYYY"
    },
    "yearPicker": {
        "enabled": true,
        "titleFormat": "YYYY"
    },
    "responsive": true
});

$("#task_dateEdit").pDatepicker({
    "inline": false,
    "format": "YYYY/MM/DD",
    "viewMode": "day",
    "initialValue": false,
    "initialValueType": 'persian',
    "minDate": -1539487544000,
    "maxDate": new Date().getTime(),
    "autoClose": true,
    "position": "auto",
    "altField": "#txtBirthday",
    "onlyTimePicker": false,
    "onlySelectOnDate": true,
    "calendarType": "persian",
    "inputDelay": 800,
    "observer": true,
    "calendar": {
        "persian": {
            "locale": "fa",
            "showHint": true,
            "leapYearMode": "algorithmic"
        }
    },
    "navigator": {
        "enabled": true,
        "scroll": {
            "enabled": true
        },
        "text": {
            "btnNextText": "<",
            "btnPrevText": ">"
        }
    },
    "toolbox": {
        "enabled": true,
        "calendarSwitch": {
            "enabled": false,
            "format": "MMMM"
        },
        "todayButton": {
            "enabled": true,
            "text": {
                "fa": "امروز",
                "en": "Today"
            }
        },
        "submitButton": {
            "enabled": true,
            "text": {
                "fa": "بستن",
                "en": "Submit"
            }
        },
        "text": {
            "btnToday": "امروز"
        }
    },
    "timePicker": {
        "enabled": false,
        "step": 1,
        "hour": {
            "enabled": true,
            "step": null
        },
        "minute": {
            "enabled": true,
            "step": null
        },
        "second": {
            "enabled": false,
            "step": null
        },
        "meridian": {
            "enabled": false
        }
    },
    "dayPicker": {
        "enabled": true,
        "titleFormat": "YYYY MMMM"
    },
    "monthPicker": {
        "enabled": true,
        "titleFormat": "YYYY"
    },
    "yearPicker": {
        "enabled": true,
        "titleFormat": "YYYY"
    },
    "responsive": true
});

persianNumbers = [/۰/g, /۱/g, /۲/g, /۳/g, /۴/g, /۵/g, /۶/g, /۷/g, /۸/g, /۹/g]
arabicNumbers = [/٠/g, /١/g, /٢/g, /٣/g, /٤/g, /٥/g, /٦/g, /٧/g, /٨/g, /٩/g]
convertToEnglishDigits = function (str) {
    if (typeof str === 'string') {
        for (var i = 0; i < 10; i++) {
            str = str.replace(persianNumbers[i], i).replace(arabicNumbers[i], i);
        }
    }
    return str;
};

function createNew() {
    //before ajax request this section clear the message input value
    axios.interceptors.request.use(function (config) {
        $.blockUI({
            message:
                '<div class="d-flex justify-content-center"><p class="mb-0">لطفا صبر کنید...</p> <div class="sk-wave m-0 ms-2"><div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div></div> </div>',
            timeout: 1000,
            css: {
                backgroundColor: 'transparent',
                color: '#fff',
                border: '0',
                width: '80%'
            },
            overlayCSS: {
                opacity: 0.5
            }
        });

        return config
    });
    axios({
        url: '/kara-fa/tasks/store',
        method: 'post',
        data: {
            task_date : convertToEnglishDigits($('#task_date').val()),
            description: $('#description .ql-editor').html(),
            is_present: $('input[name="is_present"]:checked').val()
        }
    })
        .then(function (response) {
            $('#tasks-list').prepend(`
                <tr>
                            <td>
                                تسک های
                                <strong>${response.data.task_date}</strong>
                            </td>
                            <td>
                            ${response.data.item.description}
</td>
 <td>
            <button data-bs-toggle="modal"
                               data-bs-target="#editItemModal"
                               class="btn btn-sm btn-info item-edit"
                               onclick="showEditDetails(${response.data.item.id})"
                               type="button">ویرایش</button>
                            <button class="btn btn-sm btn-danger"
                                    onclick="removeItem(${response.data.item.id} , $(this))"
                                    type="button">حذف</button></td>

                        </tr>
            `)
            $('#modalCenter').modal('toggle');

        })
        .catch(function(response) {
            const Toast = Swal.mixin({
                toast: true,
                position: "bottom-left",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "error",
                title: response.response.data.message
            });
        })

}
const snowEditor = new Quill('#description', {
    bounds: '#description',
    modules: {
        formula: true,
        toolbar: '#description-toolbar'
    },
    theme: 'snow'
});

const snowEditor2 = new Quill('#descriptionEdit', {
    bounds: '#descriptionEdit',
    modules: {
        formula: true,
        toolbar: '#descriptionEdit-toolbar'
    },
    theme: 'snow'
});


function showEditDetails(id) {
    let date = convertToEnglishDigits($('#task_dateEdit'))
    let description = $('#descriptionEdit .ql-editor')
    let editBtn = $('#edit-submit-btn');
    editBtn.attr('onclick', `editItemSubmit(${id})`)

    //before ajax request this section clear the message input value
    axios.interceptors.request.use(function (config) {
        $.blockUI({
            message:
                '<div class="d-flex justify-content-center"><p class="mb-0">لطفا صبر کنید ...</p> <div class="sk-wave m-0 ms-2"><div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div></div> </div>',
            timeout: 1000,
            css: {
                backgroundColor: 'transparent',
                color: '#fff',
                border: '0',
                width: '80%'
            },
            overlayCSS: {
                opacity: 0.5
            }
        });

        return config
    });
    axios.get(`/kara-fa/tasks/edit/${id}`)
        .then((response) => {
            date.val(response.data.item.date)
            description.html(response.data.item.description)
        })
}

function editItemSubmit(id) {
    let date = convertToEnglishDigits($('#task_dateEdit').val())
    let description = $('#descriptionEdit .ql-editor').html()
    axios.interceptors.request.use(function (config) {
        $.blockUI({
            message:
                '<div class="d-flex justify-content-center"><p class="mb-0">لطفا صبر کنید ...</p> <div class="sk-wave m-0 ms-2"><div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div></div> </div>',
            timeout: 1000,
            css: {
                backgroundColor: 'transparent',
                color: '#fff',
                border: '0',
                width: '80%'
            },
            overlayCSS: {
                opacity: 0.5
            }
        });

        return config
    });
    axios.patch(`/kara-fa/tasks/update/${id}`, {
        date: convertToEnglishDigits(date),
        description: description,
    })
        .then((response) => {

            $('#editItemModal').modal('toggle');
            $(`*[data-id=${response.data.item.id}]`).html('')
            $(`*[data-id=${response.data.item.id}]`).html(`

            <td>تسک های ${response.data.task_date}</td>
            <td> ${response.data.item.description}</td>
            <td>
            <button data-bs-toggle="modal"
                               data-bs-target="#editItemModal"
                               class="btn btn-sm btn-info item-edit"
                               onclick="showEditDetails(${response.data.item.id})"
                               type="button">ویرایش</button>
                            <button class="btn btn-sm btn-danger"
                                    onclick="removeItem(${response.data.item.id} , $(this))"
                                    type="button">حذف</button></td>

            `)
            const Toast = Swal.mixin({
                toast: true,
                position: "bottom-left",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "success",
                title: response.data.message
            });
        })
        .catch((response) => {
            const Toast = Swal.mixin({
                toast: true,
                position: "bottom-left",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "error",
                title: response.response.data.message
            });
        })
}

function removeItem(id, e) {
    const swalWithBootstrapButtons = Swal.mixin({
        customClass: {
            confirmButton: "btn btn-danger ms-3",
            cancelButton: "btn btn-secondary"
        },
        buttonsStyling: false
    });
    swalWithBootstrapButtons.fire({
        title: "آیا از حذف آیتم مطمئن هستید؟",
        text: "این عمل غیر قابل بازگشت میباشد",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "حذف",
        cancelButtonText: "لغو",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            //before ajax request this section clear the message input value
            axios.interceptors.request.use(function (config) {
                $('.swal2-confirm').html('<span class="spinner-border me-2" role="status" aria-hidden="true"></span>')
                $.blockUI({
                    message:
                        '<div class="d-flex justify-content-center"><p class="mb-0">لطفا صبر کنید ...</p> <div class="sk-wave m-0 ms-2"><div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div> <div class="sk-rect sk-wave-rect"></div></div> </div>',
                    timeout: 1000,
                    css: {
                        backgroundColor: 'transparent',
                        color: '#fff',
                        border: '0',
                        width: '80%'
                    },
                    overlayCSS: {
                        opacity: 0.5
                    }
                });

                return config
            });
            axios.delete(`/kara-fa/tasks/destroy/${id}`)
                .then((response) => {
                    e.parent().parent().remove()
                    const Toast = Swal.mixin({
                        toast: true,
                        position: "bottom-left",
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.onmouseenter = Swal.stopTimer;
                            toast.onmouseleave = Swal.resumeTimer;
                        }
                    });
                    Toast.fire({
                        icon: "success",
                        title: response.data.message
                    });
                })
                .catch((response) => {
                    const Toast = Swal.mixin({
                        toast: true,
                        position: "bottom-left",
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.onmouseenter = Swal.stopTimer;
                            toast.onmouseleave = Swal.resumeTimer;
                        }
                    });
                    Toast.fire({
                        icon: "error",
                        title: response.response.data.message
                    });
                })
        }
    });


}
