import fa from '/assets/admin/js/grapesjs/fa.js';

const editor = grapesjs.init({
    storageManager:false,
    canvas: {
        styles: [
            '/assets/front/css/icons/bootstrap-icons/font/bootstrap-icons.min.css',
            '/assets/front/vendor/owl-carousel/owl.carousel.css',
            '/assets/front/css/app.css',
        ],
        scripts : [
            '/assets/front/vendor/owl-carousel/owl.carousel.js',
            '/assets/front/js/bootstrap/bootstrap.min.js',
            '/assets/front/js/bootstrap/popper.min.js',
            '/assets/front/js/jquery-ui.min.js',
            '/assets/front/js/jquery.js',
            '/assets/front/js/app.js',
        ]
    },
    container : '#gjs',
    fromElement: true,
    i18n: {
        locale: 'fa', // default locale
        // detectLocale: true, // by default, the editor will detect the language
        // localeFallback: 'en', // default fallback
        // messages: { it, tr },
    },
    plugins: [
        'grapesjs-parser-postcss',
        'gjs-plugin-ckeditor' ,
    ],

    pluginsOpts: {
        'gjs-plugin-ckeditor': {
            position: 'right',
            options: {
                startupFocus: true,
                language: 'fa',
                extraAllowedContent: '*(*);*{*}', // Allows any class and any inline style
                allowedContent: true, // Disable auto-formatting, class removing, etc.
                enterMode: CKEDITOR.ENTER_BR,
                extraPlugins: 'sharedspace,justify,colorbutton,panelbutton,font,format,list,tabletools,table,tableselection',
                toolbar: [
                    { name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'] },
                    { name: 'editing', items: ['Find', 'Replace', '-', 'SelectAll', '-', 'Scayt'] },
                    { name: 'forms', items: ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField'] },
                    '/',
                    { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'CopyFormatting', 'RemoveFormat'] },
                    { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl', 'Language'] },
                    { name: 'links', items: ['Link', 'Unlink', 'Anchor'] },
                    { name: 'insert', items: ['Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe'] },
                    '/',
                    { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize'] }, // Add 'Format' here
                    { name: 'colors', items: ['TextColor', 'BGColor'] },
                    { name: 'tools', items: ['Maximize', 'ShowBlocks'] },
                ],
                format_tags: 'p;h1;h2;h3;h4;h5;h6', // Customize the formats available in the dropdown

                i18n: {
                    // locale: 'fa', // default locale
                    // detectLocale: false, // by default, the editor will detect the language
                    // localeFallback: 'fa', // default fallback
                    messages: {fa},
                }
            }
        }
    },
    assetManager: {
        storageType  	: 'local',
        storeOnChange  : true,
        storeAfterUpload  : true,
        upload: 'uploads',        //for temporary storage
        assets    	: [ ],
        uploadFile: function(e) {
            var files = e.dataTransfer ? e.dataTransfer.files : e.target.files;
            var formData = new FormData();
            for(var i in files){
                formData.append('file-'+i, files[i]) //containing all the selected images from local
            }
            $.ajax({
                url: '/kara-fa/pagebuilder/uploader',
                type: 'POST',
                data: formData,
                contentType:false,
                crossDomain: true,
                dataType: 'json',
                mimeType: "multipart/form-data",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                processData:false,
                success: function(result){
                    var myJSON = [];
                    $.each( result['data'], function( key, value ) {
                        myJSON[key] = value;
                    });
                    var images = myJSON;
                    editor.AssetManager.add(images); //adding images to asset manager of GrapesJS
                }
            });
        },
    },
});

editor.getWrapper().addClass("gjs-wrapper");

editor.Css.setRule('.gjs-wrapper', {
    direction: "rtl"
});
editor.Panels.addButton
('options',
    [{
        id: 'save-db',
        className: 'fa fa-floppy-o',
        command: 'save-db',
        attributes: {title: 'Save DB'}
    }]
);
editor.Panels.addButton
('options',
    [{
        id: 'back',
        className: 'fa fa-arrow-left',
        command: 'back',
        attributes: {title: 'بازگشت'}
    }]
);

// Add the command
editor.Commands.add
('save-db',
    {
        run: function(editor, sender)
        {
            sender && sender.set('active', 0); // turn off the button
            editor.store();

            var htmldata = editor.getHtml();
            var cssdata = editor.getCss();
            var page_id = document.getElementById('page-id');
            const adminPrefix = $("meta[name='admin-prefix']").attr("content");
            axios.post(`/${adminPrefix}/pagebuilder`, {
                content: htmldata,
                pagebuilder_type: $('#pagebuilder_type').val(),
                pagebuilder_id: $('#pagebuilder_id').val(),
            })
                .then(res => success(res))
                .catch(err => failed(err))
            function success(res) {
                Swal.fire({
                    icon: 'success',
                    title: 'موفق',
                    text: res.data.message,
                    confirmButtonText: 'باشه'
                })
                window.location.replace(res.data.redirect)
            }
            function failed(err) {
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    text: err.data.message,
                    confirmButtonText: 'باشه'
                })
            }
        }
    });
// Add the command
editor.BlockManager.add('rose-call-to-action', {
    label: 'کال تو اکشن',
    content:`
        <div class="call-to-action-single-product br-default d-flex flex-column align-items-center justify-content-center g-4">
            <img src="/uploads/Headphones-Customer-support.svg" alt="">
            <h3 class="title text-white">تماس با کارشناسان</h3>
            <p class="desc text-white">ارتباط با کارشناسان ما از طریق تماس تلفنی</p>
            <a href="tel:02191691548" class="btn btn-light">021-91691548</a>
        </div>
    `
});

editor.BlockManager.add('rose-container', {
    label: 'کانتینر',
    content:`
        <div class="container">
        <div class="row">
        کانتینر
</div>
</div>
    `
});

editor.BlockManager.add('rose-2-columns', {
    label: 'ردیف ۲ ستونه',
    content:`
        <div class="row">
        <div class="col-md-6">
        <p>ردیف اول</p>
</div>
        <div class="col-md-6">
        <p>
        ردیف دوم
</p>
</div>
        </div>`
});

editor.BlockManager.add('rose-2-columns-1', {
    label: 'ردیف ۲ ستونه طرح ۱',
    content:`
        <div class="row">
        <div class="col-md-4">
        <p>ردیف اول</p>
</div>
        <div class="col-md-8">
        <p>
        ردیف دوم
</p>
</div>
        </div>`
});


editor.BlockManager.add('rose-2-image', {
    label: 'تصویر',
    content:`
    <img src="#">
        `
});

editor.BlockManager.add('rose-2-video', {
    label: 'ویدیو',
    content:`
    <video controls src="#" class="w-100">
        `
});

editor.BlockManager.add('rose-3-columns', {
    label: 'ردیف ۳ ستونه',
    content:`
        <div class="row">
        <div class="col-md-4">
        <div>
         <p>ردیف اول</p>
</div>

</div>
        <div class="col-md-4">
        <div>
          <p>
        ردیف دوم
</p>
</div>

</div>
<div class="col-md-4">
    <div>
        <p>
        ردیف سوم
</p>
</div>
</div>
        </div>`
});

editor.BlockManager.add('rose-4-columns', {
    label: 'ردیف ۴ ستونه',
    content:`
        <div class="row">
        <div class="col-md-3">
        <p>ردیف اول</p>
</div>
        <div class="col-md-3">
        <p>
        ردیف دوم
</p>
</div>
<div class="col-md-3">
        <p>
        ردیف سوم
</p>
</div>
<div class="col-md-3">
        <p>
        ردیف چهارم
</p>
</div>
        </div>`
});


editor.BlockManager.add('rose-space', {
    label: 'فاصله',
    activate: true,
    content:`
        <div class="row my-4">

</div>
        </div>`
});

editor.BlockManager.add('rose-acardeon', {
    label: 'آکاردئون',
    activate: true,
    content:`
        <div class="accordion" id="accordionExample">
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        آیا دوره ها حضوری هستند؟
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample" style="">
                                    <div class="accordion-body row">
                                       <style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}</style><div class="h_iframe-aparat_embed_frame"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/ldpp519/vt/frame"  allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        شرایط عضویت در کانال جامع چیست؟
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample" style="">
                                    <div class="accordion-body">
                                        کانال جامع “بررسی و تحلیل سهام” مخصوص دانش پذیران دوره “FIS” و “افزایش سرمایه” می&zwnj;باشد.
                                        چون سطح مطالب کانال بالا است و اگر آموزش ندیده باشید متوجه مطالب کانال نخواهید شد. جناب
                                        دکتر خسروانی به صورت روزانه در کانال فعالیت می&zwnj;کنند و همه&zwnj;ی سهم ها رو تحلیل می&zwnj;کنند.
                                        مشاوره مستقیم با خود جناب دکتر هست و شما می&zwnj;توانید طبق توصیه ها و راهنمایی های ایشون با
                                        آرامش سهم خرید و فروش کنید و از سرمایه گذاری در بازار بورس لذت ببرید.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        شرایط مشاوره با دکتر بردیا خسروانی چیست؟
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        جناب دکتر خسروانی مشاوره حضوری یا تلفنی ندارند به علت اینکه ایشان اعتقاد دارند پشتیبانی
                                        دوره ها باید بی نقص، دقیق و حرفه ای انجام شود، بنا بر این به شخصه پشتیبانی حدود 7000
                                        دانشپذیر را به عهده گرفتند و هر گونه مشاوره و راهنمایی به دانش&zwnj;پذیران&zwnj;شان می&zwnj;دهند. در
                                        صورتی که شما دانش&zwnj;پذیر هریک از دوره های مسیر ثروت ساز، افزایش سرمایه، fis و حسابدار نخبه
                                        باشید، می&zwnj;توانید با ایشان در هر زمینه مشورت کنید و سوالات خودتان را از ایشان بپرسید.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingFour">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="headingFour">
                                        پرداخت اقساطی به چه صورت است؟
                                    </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        دوره ها با تخفیف ویژه لحاظ شده و شرایط ثبت نام برای همه ی عزیزان یکسان است. با عرض پوزش
                                        پرداخت اقساطی امکان پذیر نمی&zwnj;باشد چون قیمت ها کارشناسی شده است.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingSix">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="headingSix">
                                        چگونه اسپات پلیر را نصب و لایسنس خود را وارد کنیم؟
                                    </button>
                                </h2>
                                <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div id="79080916845"><style>.h_iframe-aparat_embed_frame{position:relative;} .h_iframe-aparat_embed_frame .ratio {display:block;width:100%;height:auto;} .h_iframe-aparat_embed_frame iframe {position:absolute;top:0;left:0;width:100%; height:100%;}</style><div class="h_iframe-aparat_embed_frame"> <span style="display: block;padding-top: 57%"></span><iframe width="100%" height="100%" title="نحوه دانلود و استفاده از اسپات پلیر _ دکتر بردیا خسروانی" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="https://www.aparat.com/video/video/embed/videohash/laenauw/vt/frame"></iframe></div></div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingSeven">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="headingSeven">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingEight">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight" aria-expanded="false" aria-controls="headingEight">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingNine">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine" aria-expanded="false" aria-controls="headingNine">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingTen">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen" aria-expanded="false" aria-controls="headingTen">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseTen" class="accordion-collapse collapse" aria-labelledby="headingTen" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingEleven">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEleven" aria-expanded="false" aria-controls="headingEleven">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseEleven" class="accordion-collapse collapse" aria-labelledby="headingEleven" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingTwelve">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwelve" aria-expanded="false" aria-controls="headingTwelve">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseTwelve" class="accordion-collapse collapse" aria-labelledby="headingTwelve" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="headingThirteen">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThirteen" aria-expanded="false" aria-controls="headingThirteen">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapseThirteen" class="accordion-collapse collapse" aria-labelledby="headingThirteen" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading14">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse14" aria-expanded="false" aria-controls="heading14">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapse14" class="accordion-collapse collapse" aria-labelledby="heading14" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                        </div>`
});

editor.BlockManager.add('rose-acardeon-2', {
    label: 'آکاردئون 2',
    activate: true,
    content:`
        <div class="accordion" id="accordionExample2">
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading1">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                                        آیا دوره ها حضوری هستند؟
                                    </button>
                                </h2>
                                <div id="collapse1" class="accordion-collapse collapse show" aria-labelledby="heading1" data-bs-parent="#accordionExample2" style="">
                                    <div class="accordion-body">
                                        دوره ها به صورت مجازی و با فرمت ویدئو های ضبط شده در بستر اسپات پلیر هستند. این فایل ها
                                        بعد از ثبت نام بدون محدودیت زمانی در دسترس شما قرار خواهد گرفت.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading2">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
                                        شرایط عضویت در کانال جامع چیست؟
                                    </button>
                                </h2>
                                <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2" data-bs-parent="#accordionExample2" style="">
                                    <div class="accordion-body">
                                        کانال جامع “بررسی و تحلیل سهام” مخصوص دانش پذیران دوره “FIS” و “افزایش سرمایه” می&zwnj;باشد.
                                        چون سطح مطالب کانال بالا است و اگر آموزش ندیده باشید متوجه مطالب کانال نخواهید شد. جناب
                                        دکتر خسروانی به صورت روزانه در کانال فعالیت می&zwnj;کنند و همه&zwnj;ی سهم ها رو تحلیل می&zwnj;کنند.
                                        مشاوره مستقیم با خود جناب دکتر هست و شما می&zwnj;توانید طبق توصیه ها و راهنمایی های ایشون با
                                        آرامش سهم خرید و فروش کنید و از سرمایه گذاری در بازار بورس لذت ببرید.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading3">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
                                        شرایط مشاوره با دکتر بردیا خسروانی چیست؟
                                    </button>
                                </h2>
                                <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading3" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        جناب دکتر خسروانی مشاوره حضوری یا تلفنی ندارند به علت اینکه ایشان اعتقاد دارند پشتیبانی
                                        دوره ها باید بی نقص، دقیق و حرفه ای انجام شود، بنا بر این به شخصه پشتیبانی حدود 7000
                                        دانشپذیر را به عهده گرفتند و هر گونه مشاوره و راهنمایی به دانش&zwnj;پذیران&zwnj;شان می&zwnj;دهند. در
                                        صورتی که شما دانش&zwnj;پذیر هریک از دوره های مسیر ثروت ساز، افزایش سرمایه، fis و حسابدار نخبه
                                        باشید، می&zwnj;توانید با ایشان در هر زمینه مشورت کنید و سوالات خودتان را از ایشان بپرسید.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading4">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="heading4">
                                        پرداخت اقساطی به چه صورت است؟
                                    </button>
                                </h2>
                                <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="heading4" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        دوره ها با تخفیف ویژه لحاظ شده و شرایط ثبت نام برای همه ی عزیزان یکسان است. با عرض پوزش
                                        پرداخت اقساطی امکان پذیر نمی&zwnj;باشد چون قیمت ها کارشناسی شده است.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading6">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false" aria-controls="heading6">
                                        چگونه اسپات پلیر را نصب و لایسنس خود را وارد کنیم؟
                                    </button>
                                </h2>
                                <div id="collapse6" class="accordion-collapse collapse" aria-labelledby="heading6" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        <div id="79080916845"><style>.h_iframe-aparat_embed_frame{position:relative;} .h_iframe-aparat_embed_frame .ratio {display:block;width:100%;height:auto;} .h_iframe-aparat_embed_frame iframe {position:absolute;top:0;left:0;width:100%; height:100%;}</style><div class="h_iframe-aparat_embed_frame"> <span style="display: block;padding-top: 57%"></span><iframe width="100%" height="100%" title="نحوه دانلود و استفاده از اسپات پلیر _ دکتر بردیا خسروانی" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="https://www.aparat.com/video/video/embed/videohash/laenauw/vt/frame"></iframe></div></div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading7">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse7" aria-expanded="false" aria-controls="heading7">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapse7" class="accordion-collapse collapse" aria-labelledby="heading7" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading8">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse8" aria-expanded="false" aria-controls="heading8">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapse8" class="accordion-collapse collapse" aria-labelledby="heading8" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="heading9">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse9" aria-expanded="false" aria-controls="heading9">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="collapse9" class="accordion-collapse collapse" aria-labelledby="heading9" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="h10">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-10" aria-expanded="false" aria-controls="h10">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="c-10" class="accordion-collapse collapse" aria-labelledby="h10" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="h-11">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-11" aria-expanded="false" aria-controls="h-11">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="c-11" class="accordion-collapse collapse" aria-labelledby="h-11" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="h-12">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-12" aria-expanded="false" aria-controls="h-12">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="c-12" class="accordion-collapse collapse" aria-labelledby="h-12" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="h-13">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-13" aria-expanded="false" aria-controls="h-13">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="c-13" class="accordion-collapse collapse" aria-labelledby="h-13" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                              <div class="accordion-item py-2 br-default">
                                <h2 class="accordion-header" id="h-14">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-14" aria-expanded="false" aria-controls="h-14">
                                        برای مشاهده دوره&zwnj;ها محدودیت زمانی داریم؟
                                    </button>
                                </h2>
                                <div id="c-14" class="accordion-collapse collapse" aria-labelledby="h-14" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        خیر؛ در هر زمان و مکان، شما با داشتن اینترنت فعال می&zwnj;توانید به دوره ها دسترسی داشته
                                        باشید.
                                    </div>
                                </div>
                            </div>
                        </div>`
});


editor.BlockManager.add('rose-text', {
    label: 'متن ساده',
    content:`
   <div class="row line-height-default my-2">
   لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.
</div>
        </div>
        `
});
editor.BlockManager.add('rose-title', {
    label: 'عنوان با تصویر',
    content:`
   <div class="title-box no-line">
            <div class="title-wrapper">
                    <img src="/uploads/comment-woo.svg" alt="">

                <h3 class="title title-line">
                    عنوان
                </h3>
            </div>
        </div>
        `
});

editor.BlockManager.add('rose-7-years-road', {
    label: 'مسیر ۷ ساله',
    content:`
   <div class="hex-container">
        <div class="hex-row">
            <a href="#daramad" id="daramad-item">
                <div class="hexagon">کسب درآمد بیشتر</div>
            </a>
            <a href="#barname" id="barname-item">
                <div class="hexagon">برنامه ریزی و اولویت بندی</div>
            </a>
        </div>
        <div class="hex-row">
            <a href="#varzesh" id="varzesh-item">
                <div class="hexagon">ورزش جسم و ذهن</div>
            </a>
            <a href="#amoozesh" id="amoozesh-item">
                <div class="hexagon hex-center">آموزش</div>
            </a>
            <a href="#moshavere" id="moshavere-item">
                <div class="hexagon">مشاوره و راهنما</div>
            </a>
        </div>
        <div class="hex-row">
            <a href="#ijad" id="ijad-item">
                <div class="hexagon">ایجاد درآمد غیرفعال</div>
            </a>
            <a href="#hazine" id="hazine-item">
                <div class="hexagon">کنترل هزینه و مخارج</div>
            </a>
        </div>
    </div>
        `
});

editor.BlockManager.add('rose-icon-box-1', {
    label: 'آیکون باکس ۱',
    content:`
    <div class="icon-box-about">
                    <img src="/uploads/teacher.svg" alt="">

                    <div class="content p-3 mt-3 br-default">
                        <p>
                            بیش از 15 هزار دانش پذیر در طول مسیر خدمت رسانی
                        </p>
                    </div>
                </div>
        `
});

editor.BlockManager.add('rose-button', {
    label: 'دکمه',
    content:`
    <a href="#" class="btn btn-default w-100 mt-4">عنوان</a>
        `
});

editor.BlockManager.add('rose-faq', {
    label: 'سوالات متداول',
    content:`
            <div class="d-flex align-items-center justify-content-center">
                <div class="accordion" id="accordionExample">
                    <div class="accordion-item py-2 br-default">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                آیا دوره ها حضوری هستند؟
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                             data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                دوره ها به صورت مجازی و با فرمت ویدئو های ضبط شده در بستر اسپات پلیر هستند. این فایل ها
                                بعد از ثبت نام بدون محدودیت زمانی در دسترس شما قرار خواهد گرفت.
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item py-2 br-default">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                شرایط عضویت در کانال جامع چیست؟
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                             data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                کانال جامع “بررسی و تحلیل سهام” مخصوص دانش پذیران دوره “FIS” و “افزایش سرمایه” می‌باشد.
                                چون سطح مطالب کانال بالا است و اگر آموزش ندیده باشید متوجه مطالب کانال نخواهید شد. جناب
                                دکتر خسروانی به صورت روزانه در کانال فعالیت می‌کنند و همه‌ی سهم ها رو تحلیل می‌کنند.
                                مشاوره مستقیم با خود جناب دکتر هست و شما می‌توانید طبق توصیه ها و راهنمایی های ایشون با
                                آرامش سهم خرید و فروش کنید و از سرمایه گذاری در بازار بورس لذت ببرید.
                            </div>
                        </div>
                    </div>

                </div>
        </div>

        `
});



editor.BlockManager.add('rose-full-page-single-product-free', {
    label: 'محصول رایگان فول',
    content:`
     <!--top nav product-->
        <div class="single-product-nav my-5">
            <ul class="p-0">
                <li>
                    <a href="#desc">توضیحات</a>
                </li>
                <li>
                    <a href="#preview">
                        ویدیو معرفی
                    </a>
                </li>
                <li>
                    <a href="#lessons">
                        سرفصل ها
                    </a>
                </li>
                <li>
                    <a href="#teacher">
                        مدرس
                    </a>
                </li>
                <li>
                    <a href="#faq">
                        سوالات متداول
                    </a>
                </li>
                <li>
                    <a href="#comments">
                        نظرات
                    </a>
                </li>

            </ul>
        </div>
        <!--top nav product wns-->

        <div class="row gx-5">
            <h1 class="mb-3">مدیریت زندگی مالی (FLM)</h1>
            <div class="col-md-4 ">
                <div class="bg-white br-default h-100">
                    <ul class=" rose-playlist-course ">
                        <li>
                            <a class="select-video" data-video-src="https://roseoj.com/product/%d8%af%d9%88%d8%b1%d9%87-%d9%85%d9%82%d8%af%d9%85%d8%a7%d8%aa%db%8c-%d8%a8%d9%88%d8%b1%d8%b3/">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                     fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                          stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                          stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <script xmlns=""/>
                                </svg>
                                شروع مسیر تحلیل بنیادی بورس ( مقدمه )
                            </a>
                        </li>
                        <li>
                            <a class="select-video" data-video-src="https://karawebs.com/farshad">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                     fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                          stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                          stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <script xmlns=""/>
                                </svg>
                                هدف از سرمایه گذاری در بورس
                            </a>
                        </li>
                        <li>
                            <a class="select-video" data-video-src="https://roseoj.com/product/%d8%af%d9%88%d8%b1%d9%87-%d9%85%d9%82%d8%af%d9%85%d8%a7%d8%aa%db%8c-%d8%a8%d9%88%d8%b1%d8%b3/">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                     fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                          stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                          stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <script xmlns=""/>
                                </svg>
                                چرا بورس و مقایسه با سایر بازارها
                            </a>
                        </li>
                        <li><a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <script xmlns=""/>
                            </svg>
                            چرا بازدهی بالاست</a>
                        </li>
                        <li><a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <script xmlns=""/>
                            </svg>
                            چرا بازدهی بالاست</a>
                        </li>
                        <li><a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <script xmlns=""/>
                            </svg>
                            چرا بازدهی بالاست</a>
                        </li>
                        <li><a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <script xmlns=""/>
                            </svg>
                            چرا بازدهی بالاست</a>
                        </li>
                        <li><a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <script xmlns=""/>
                            </svg>
                            چرا بازدهی بالاست</a>
                        </li>
                        <li><a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                 fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M12.764 10.5676L17.293 13.2463C17.8659 13.5846 17.8659 14.4141 17.293 14.7525L12.764 17.4311C12.1807 17.7765 11.4434 17.3553 11.4434 16.6775V11.3213C11.4434 10.6435 12.1807 10.2223 12.764 10.5676V10.5676Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M21 24.5H7C5.06683 24.5 3.5 22.9332 3.5 21V7C3.5 5.06683 5.06683 3.5 7 3.5H21C22.9332 3.5 24.5 5.06683 24.5 7V21C24.5 22.9332 22.9332 24.5 21 24.5Z"
                                      stroke="#0FABB5" stroke-width="1.75" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <script xmlns=""/>
                            </svg>
                            چرا بازدهی بالاست</a>
                        </li>
                    </ul>

                </div>
            </div>
            <div class="col-md-8">
                <video class="rose-video-player" width="100%" src="" controls></video>
            </div>
        </div>


        <div class="my-5">
            <div class="row">
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="bg-white p-4 br-default">
                    <p>محتوا</p>
                </div>

            </div>
            <div class="col-md-4">
                <div class="bg-white p-4 br-default single-product-sidebar">
                    <img src="assets/images/fis.jpg" alt="" class="br-default">

                    <div class="product-sidebar-details mt-4">
                        <h3>دوره مستر FIS</h3>
                        <p class="text-justify">
                            سیستم معاملاتی FIS (Financial Investing System) یک سیستم منحصر به فرد، توسط دکتر بردیا
                            خسروانی،
                            مدرس برجسته بازارهای مالی با 15 سال سابقه ی درخشان، طراحی شده است تا راه را برای
                            سرمایه‌گذاران
                            در جهت کسب سود پایدار و کم‌ریسک، ایجاد درآمد غیرفعال و بازنشستگی زودهنگام در بورس ایران
                            هموار
                            کند.

                        </p>
                        <!--Add To Cart Button-->
                        <a href="#" class="btn btn-default w-100 mt-4">ثبت نام در دوره</a>
                        <!--Add To Cart Button End-->
                    </div>
                </div>
            </div>
        </div>
        `
});

editor.BlockManager.add('rose-product-part-1', {
    label: 'المان محصول - بخش تصویر و معرفی',
    content:`
                <div class="bg-white br-default p-5">
            <div class="row gx-5">
                <div class="col-md-7 align-self-center">
                    <div class="product-short-details d-flex flex-column align-items-start gap-4">
                        <h1>مدیریت زندگی مالی (FLM)</h1>
                        <p class="short-desc">
                            در دنیای پرشتاب و پیچیده بازارهای مالی، معامله‌گری صرفاً به دانش و علم مالی محدود نمی‌شود،
                            قدرت
                            ذهن و هوش روانشناختی نقشی اساسی در کسب سود و پرهیز از ضرر و همچنین موفقیت …
                        </p>


                        <div class="d-flex flex-wrap justify-content-center justify-content-lg-between w-100 align-items-center my-4 my-lg-0">
                            <!--Add To Cart Button-->
                            <a href="#" class="btn btn-default">ثبت نام در دوره</a>
                            <!--Add To Cart Button End-->

                            <div class="product-price mt-4 mt-lg-0">
                                <span class="discount-badge mb-3">28% تخفیف</span>
                                <p class="old-price">30.000.000
                                    <span class="prefix">تومان</span>
                                </p>
                                <p class="new-price">50.000.000
                                    <span class="prefix">تومان</span>
                                </p>
                            </div>

                        </div>

                    </div>

                </div>
                <div class="col-md-5">
                    <img src="assets/images/fis.jpg" alt="" class="br-default">
                </div>
            </div>
        </div>

        `
});

editor.BlockManager.add('rose-product-part-2', {
    label: 'المان محصول - بخش منو',
    content:`
                     <!--top nav product-->
        <div class="single-product-nav my-5">
            <ul class="p-0">
                <li>
                    <a href="#desc">توضیحات</a>
                </li>
                <li>
                    <a href="#preview">
                        ویدیو معرفی
                    </a>
                </li>
                <li>
                    <a href="#lessons">
                        سرفصل ها
                    </a>
                </li>
                <li>
                    <a href="#teacher">
                        مدرس
                    </a>
                </li>
                <li>
                    <a href="#faq">
                        سوالات متداول
                    </a>
                </li>
                <li>
                    <a href="#comments">
                        نظرات
                    </a>
                </li>

            </ul>
        </div>
        <!--top nav product wns-->

        `
});

editor.BlockManager.add('rose-product-part-3', {
    label: 'المان محصول - بخش آیکن ها',
    content:`
        <div class="my-5">
            <div class="row">
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="icon-box-inline">
                        <div class="content">
                            <h3 class="title">روانشاسی مالی</h3>
                            <p class="desc">پــــوشش کامل مـــسائل</p>
                        </div>
                        <img src="assets/images/lamp-spark.svg" alt="">

                    </div>
                </div>
            </div>
        </div>


        `
});


editor.BlockManager.add('rose-product-part-4', {
    label: 'المان محصول - بخش محتوا',
    content:`
        <div class="row">
            <div class="col-md-8">
                <div class="bg-white p-4 br-default">
                                  <div class="row">

</div>
                </div>

                <div class="bg-white br-default p-4 mt-4">
                    <!--Start Of Comments Section-->
                    <div class="comments" id="comments">
                        <div class="title-box no-line">
                            <div class="title-wrapper">
                                <h3 class="title title-line">
                                    <img src="assets/images/comment-woo.svg" alt="">
                                    نظرات
                                </h3>
                            </div>
                        </div>
                        <ul>
                            <li class="comment-item">
                                <img src="../../assets/images/elements/avatars/avatar-5.jpg" alt="">
                                <div class="comment-details">
                                    <div class="comment-user-date">
                                        <span class="user-name"><a href="#">فرشاد رجب زاده</a></span>
                                        <span class="comment-date">24 دی 1403</span>
                                    </div>
                                    <div class="comment-text">
                                        <p>عالیه ممنونم</p>
                                    </div>
                                    <div class="reply mt-3">
                                        <a href="#" class="reply-button mt-3">
                                            <i class="bi bi-reply"></i>
                                            پاسخ
                                        </a>
                                    </div>
                                </div>
                            </li>
                            <li class="comment-item children">
                                <img src="../../assets/images/elements/avatars/avatar-2.jpg" alt="">
                                <div class="comment-details">
                                    <div class="comment-user-date">
                                        <span class="user-name"><a href="#">فرشاد رجب زاده</a></span>
                                        <span class="comment-date">24 دی 1403</span>
                                    </div>
                                    <div class="comment-text">
                                        <p>عالیه ممنونم</p>
                                    </div>
                                    <div class="reply mt-3">
                                        <a href="#" class="reply-button mt-3">
                                            <i class="bi bi-reply"></i>
                                            پاسخ
                                        </a>
                                    </div>
                                </div>
                            </li>


                        </ul>
                        <form action="#" class="post-comment br-default">
                            <h3 class="mt-4 mb-4">نظر خود را بنویسید</h3>
                            <input type="text" placeholder="نام" class="form-control">
                            <textarea rows="5" placeholder="نظر خود را بنویسید..." class="form-control mt-4"></textarea>
                            <input type="submit" value="ارسال" class="btn btn-default  mt-4 ">
                        </form>
                    </div>
                    <!--End Of Comments Section-->
                </div>
            </div>
            <div class="col-md-4">
                <div class="bg-white p-4 br-default single-product-sidebar">
                    <img src="assets/images/fis.jpg" alt="" class="br-default">

                    <div class="product-sidebar-details mt-4">
                        <h3>دوره مستر FIS</h3>
                        <p class="text-justify">
                            سیستم معاملاتی FIS (Financial Investing System) یک سیستم منحصر به فرد، توسط دکتر بردیا خسروانی،
                            مدرس برجسته بازارهای مالی با 15 سال سابقه ی درخشان، طراحی شده است تا راه را برای سرمایه‌گذاران
                            در جهت کسب سود پایدار و کم‌ریسک، ایجاد درآمد غیرفعال و بازنشستگی زودهنگام در بورس ایران هموار
                            کند.

                        </p>
                        <!--Add To Cart Button-->
                        <a href="#" class="btn btn-default w-100 mt-4">ثبت نام در دوره</a>
                        <!--Add To Cart Button End-->
                    </div>
                </div>
            </div>
        </div>

        `
});
