<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Modules\Product\Models\Product;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
//        app()[PermissionRegistrar::class]->forgetCachedPermissions();
        $this->seedPermissions();
        $this->seedUsers();
        $this->seedProducts();
    }

    private function seedPermissions(){

        Permission::create(['name' => 'admin-panel']);
        //
        Permission::create(['name' => 'view-users']);
        Permission::create(['name' => 'create-users']);
        Permission::create(['name' => 'edit-users']);
        Permission::create(['name' => 'delete-users']);

        //

        Permission::create(['name' => 'view-orders']);
        Permission::create(['name' => 'create-orders']);
        Permission::create(['name' => 'edit-orders']);
        Permission::create(['name' => 'delete-orders']);

        //
        Permission::create(['name' => 'view-products']);
        Permission::create(['name' => 'create-products']);
        Permission::create(['name' => 'edit-products']);
        Permission::create(['name' => 'delete-products']);


    }


    protected function seedUsers(){
        $customer = Role::create(['name' => 'customer']);
        $admin = Role::create(['name' => 'admin']);
        $admin->givePermissionTo(Permission::all());
        $user1 = \Modules\User\Models\User::factory()->create([
            'name' => 'فرشاد',
            'lastname' => 'رجب زاده',
            'phone' => '09121230374'
        ]);

        $user2 = \Modules\User\Models\User::factory()->create([
            'name' => 'علی',
            'lastname' => 'دوامی',
            'phone' => '09373463106'
        ]);

        $user1->assignRole('admin');

        $user2->assignRole('admin');
    }

    protected function seedProducts()
    {
        $product = Product::factory()->create([
            'name' => 'تست ۱',
            'image' => 'no image'
        ]);

        $product2 = Product::factory()->create([
            'name' => 'تست 2',
            'image' => 'no image'
        ]);

    }
}
