<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Foundation\Http\Middleware\PreventRequestsDuringMaintenance;

class CustomMaintenanceMode extends PreventRequestsDuringMaintenance
{
    public function handle($request, Closure $next)
    {
        if ($this->app->isDownForMaintenance()) {

            if($request->hasCookie('X-Bypass-Maintenance-Mode')) {
                return $next($request);
            }

            if ($request->is(
                config('services.admin.prefix') . '/*',
                config('services.admin.prefix'),
                'logout',
            )) {
                return $next($request);
            }
        }

        return parent::handle($request, $next);
    }

}
