<?php

namespace App\Broadcasting;

use Cryptommer\Smsir\Smsir;

class SMSPanel
{
    public function send($notifiable, $notification)
    {
        //check method exists
        if (!method_exists($notification, 'toSms')) {
            throw new \Exception('متد وجود ندارد');
        }

        //get data
        $data = $notification->toSms($notifiable);
        $phone = $data['phone'];
        $templateId = $data['template_id'];
        $code = $data['code'];

        //SMS.IR send sms by pattern system
        $send = new \Cryptommer\Smsir\Classes\Smsir();
        $parameter = new \Cryptommer\Smsir\Objects\Parameters('CODE', $code);
        $parameters = array($parameter);

        $send->Send()->Verify($phone, $templateId, $parameters);

    }
}
