@extends('admin::layouts.main')

@section('content')
    <div class="content-wrapper">
        @if($errors->any())
            <div class="alert alert-danger" style="padding-right: 80px">{{ $errors->first() }}</div>
        @endif
        <div class="flex-grow-1 p-3y">
            <div class="card mx-4">
                <div class="card-datatable table-responsive">
                    <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                        @can('create-users')
                            <div class="row mx-2 my-2">
                                <div class="col-md-20">
                                    <div
                                        class="dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-between flex-md-row flex-column mb-3 mb-md-0">
                                        <div class="row g-1 align-items-center">
                                            <div class="col-auto">
                                                <form id="search">
                                                    <div id="search" class="search-input">
                                                        <input type="search" name="search" value="{{ $search }}"
                                                               form="search"
                                                               class="form-control">
                                                    </div>
                                                </form>

                                            </div>
                                            <div class="col-auto">
                                                <button type="submit" class="btn-primary btn" form="search">جستجو
                                                </button>
                                            </div>
                                        </div>
                                        <div class="dt-buttons btn-group flex-wrap">
                                            <span class="me-4">{{ number_format($users->total()) }} آیتم</span>
                                            @can('create-users')
                                                <button class="btn add-new btn-primary"
                                                        aria-controls="DataTables_Table_0" type="button"
                                                        data-bs-toggle="offcanvas"
                                                        data-bs-target="#offcanvasAddUser"><span><i
                                                            class="bx bx-plus me-0 me-lg-2"></i><span
                                                            class="d-none d-lg-inline-block">افزودن کاربر جدید</span></span>
                                                </button>
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endcan
                        <table
                            class="table datatable-invoice border-top dataTable no-footer dtr-column table-hover table-striped"
                            id="DataTables_Table_1" aria-describedby="DataTables_Table_1_info"
                            style="width: 100%;">
                            <thead>
                            <tr>
                                <th aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1" style="width: 10%" aria-sort="ascending">نام
                                </th>
                                <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                    style="width: 10%;">نام
                                    خانوادگی
                                </th>
                                <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                    style="width: 10%;">شماره
                                    موبایل
                                </th>
                                <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                    style="width: 10%;">نقش
                                </th>
                                <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                    style="width: 12%;">تعداد سفارشات
                                </th>
                                <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                    style="width: 12%;">تاریخ ثبت نام
                                </th>
                                @can('edit-users')
                                    <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                        style="width: 2%;">جزییات
                                    </th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr>
                                    <td class="sorting_1">
                                        <div class="d-flex justify-content-start align-items-center user-name">
                                            <div class="d-flex flex-column">
                                                <span class="fw-semibold">{{ $user->name }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                    <span class="fw-semibold">
                                        {{ $user->lastname }}
                                    </span>
                                    </td>
                                    <td><span class="fw-semibold">{{ $user->phone }}</span></td>
                                    <td>
                                        <span>{{ $user->role() }}</span>
                                    </td>
                                    <td>{{$user->orders->count()}}</td>
                                    <td>{{ verta($user->created_at)->formatJalaliDateTime() }}</td>
                                    @can('edit-users')
                                        <td>
                                            <div class="d-flex gap-3 text-nowrap">
{{--                                                <a href="{{ route('admin.users.edit', $user->id) }}"--}}
{{--                                                   class="btn btn-sm btn-info">--}}
{{--                                                    ویرایش--}}
{{--                                                </a>--}}

                                                <x-admin::deletebutton data-id="{{ $user->id }}"/>

                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        {{ $users->links() }}
                    </div>

                </div>
                {{--                @can('create-users')--}}
                {{--                    <div class="offcanvas offcanvas-end" id="offcanvasAddUser"--}}
                {{--                         aria-labelledby="offcanvasAddUserLabel">--}}
                {{--                        <div class="offcanvas-header border-bottom">--}}
                {{--                            <h6 id="offcanvasAddUserLabel" class="offcanvas-title">افزودن کاربر</h6>--}}
                {{--                            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"--}}
                {{--                                    aria-label="Close"></button>--}}
                {{--                        </div>--}}
                {{--                        <div class="offcanvas-body mx-0 flex-grow-0">--}}
                {{--                            <form class="add-new-user pt-0" id="addNewUserForm"--}}
                {{--                                  action="{{ route('admin.users.store') }}"--}}
                {{--                                  method="POST">--}}
                {{--                                @csrf--}}
                {{--                                <div class="mb-3">--}}
                {{--                                    <label class="form-label" for="first_name">نام</label>--}}
                {{--                                    <input type="text" class="form-control" id="first_name" name="first_name"--}}
                {{--                                           value="{{old('first_name')}}"--}}
                {{--                                           required>--}}
                {{--                                </div>--}}
                {{--                                <div class="mb-3">--}}
                {{--                                    <label class="form-label" for="last_name">نام خانوادگی</label>--}}
                {{--                                    <input type="text" class="form-control" id="last_name" name="last_name"--}}
                {{--                                           value="{{ old('last_name') }}"--}}
                {{--                                           required>--}}
                {{--                                </div>--}}
                {{--                                <div class="mb-3">--}}
                {{--                                    <label class="form-label" for="phone">شماره موبایل</label>--}}
                {{--                                    <input type="number" class="form-control" id="phone" name="phone" maxlength="11"--}}
                {{--                                           value="{{ old('phone') }}"--}}
                {{--                                           required>--}}
                {{--                                </div>--}}
                {{--                                <button type="submit" class="btn btn-primary me-sm-3 me-1 data-submit">ثبت</button>--}}
                {{--                                <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="offcanvas">--}}
                {{--                                    انصراف--}}
                {{--                                </button>--}}
                {{--                            </form>--}}
                {{--                        </div>--}}
                {{--                    </div>--}}
                {{--                @endcan--}}
            </div>
            <x-admin::deletemodal/>
        </div>
        <div class="content-backdrop fade"></div>
    </div>

@endsection

@push('vendor')
    <script src="/assets/admin/vendor/libs/moment/moment.js"></script>
    <script src="/assets/admin/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
    <script src="/assets/admin/vendor/libs/datatables-bs5/i18n/fa.js"></script>
    <script src="/assets/admin/vendor/libs/select2/select2.js"></script>
    <script src="/assets/admin/vendor/libs/select2/i18n/fa.js"></script>
    <script src="/assets/admin/vendor/libs/formvalidation/dist/js/FormValidation.min.js"></script>
    <script src="/assets/admin/vendor/libs/formvalidation/dist/js/plugins/Bootstrap5.min.js"></script>
    <script src="/assets/admin/vendor/libs/formvalidation/dist/js/plugins/AutoFocus.min.js"></script>
    <script src="/assets/admin/vendor/libs/cleavejs/cleave.js"></script>
    <script src="/assets/admin/vendor/libs/cleavejs/cleave-phone.js"></script>
    <x-admin::deletemodalscript model="users"/>
    <script src="/assets/admin/js/autonumeric/autonumeric.min.js"></script>
    <script src="/assets/admin/js/datepicker/persian-date.min.js"></script>
    <script src="/assets/admin/js/datepicker/persian-datepicker.min.js"></script>
@endpush

