<?php

namespace Modules\User\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Auth\Models\OtpCode;
use Modules\Order\Models\Order;
use Modules\User\Database\Factories\UserFactory;
use Spatie\Permission\Traits\HasRoles;

// use Modules\User\Database\Factories\UserFactory;

class User extends \Illuminate\Foundation\Auth\User
{
    use HasFactory,HasRoles,Notifiable;

    /**
     * The attributes that are mass assignable.
     */
    protected $guarded;

    public function role()
    {
        return $this->getRoleNames()->first();
    }

    public function name(): string
    {
        return $this->first_name . " " . $this->last_name;
    }

    public function otpCodes()
    {
        return $this->hasMany(OtpCode::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

     protected static function newFactory(): UserFactory
     {
          return UserFactory::new();
     }
}
