@extends('admin::layouts.main')


@section('content')
    <div class="content-wrapper">
        <div class="flex-grow-1 p-3y">
            <!-- Users List Table -->
            <div class="card mx-4">
                <div class="card-header border-bottom">
                    <h5 class="card-title">فیلتر جستجو</h5>
                    <form action="{{ route('admin.products.index') }}" method="GET">
                        <div
                            class="d-flex justify-content-start align-items-center row py-3 gap-3 gap-md-0 primary-font">
                            <div class="col-md-3">
                                <label for="title" class="form-label">جستجو: </label>
                                <div id="search" class="search-input">
                                    <input type="search" name="search" value="{{ $search }}" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-1">
                                <button id="submit" type="submit" class="btn btn-primary mt-4 data-submit">جستجو
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-datatable table-responsive">
                    <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                        @can('create-products')
                            <div class="row mx-2 my-2">
                                <div class="col-md-20">
                                    <div
                                        class="dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-end flex-md-row flex-column mb-3 mb-md-0">

                                                        @can('create-products')
                                            <button class="btn add-new btn-primary"
                                                    aria-controls="DataTables_Table_0" type="button"
                                                    data-bs-toggle="offcanvas"
                                                    data-bs-target="#offcanvasAddUser"><span><i
                                                        class="bx bx-plus me-0 me-lg-2"></i><span
                                                        class="d-none d-lg-inline-block">افزودن محصول جدید</span></span>
                                            </button>
                                                        @endcan
                                    </div>
                                </div>
                            </div>
                        @endcan
                        <table class="table datatable-invoice border-top dataTable no-footer dtr-column table-hover table-striped"
                               id="DataTables_Table_1" aria-describedby="DataTables_Table_1_info"
                               style="width: 100%;">
                            <thead>
                            <tr>
                                <th tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1" style="width: 15%" aria-sort="ascending">نام
                                </th>
                                <th tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                    style="width: 5%;">تاریخ ساخت
                                </th>
                                @can('edit-products')
                                    <th aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                        style="width: 2%;">جزییات
                                    </th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($products as $product)
                                <tr>
                                    <td>
                                        @can('view-products')
                                            <a
                                                href="{{ route('admin.products.edit', $product) }}"
                                                class="text-body text-truncate">
                                                <span class="fw-semibold">{{ $product->name }}</span>
                                            </a>
                                        @else
                                            <span class="fw-semibold">{{ $product->name }}</span>
                                        @endcan
                                    </td>

                                    <td>{{ verta($product->created_at)->formatJalaliDateTime() }}</td>
                                    @can('edit-products')
                                        <td>
                                            <div class="d-flex gap-3 text-nowrap">
                                                <a href="{{ route('admin.products.edit', $product) }}"
                                                   class="btn btn-sm btn-info">
                                                    ویرایش
                                                </a>
                                                @can('delete-products')
                                                    <x-admin::deletebutton data-id="{{ $product->id }}"/>
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        {{ $products->links() }}
                    </div>

                </div>
            </div>
            <x-admin::deletemodal/>
        </div>
        <div class="content-backdrop fade"></div>
    </div>
    <div class="offcanvas offcanvas-end" id="offcanvasAddUser"
         aria-labelledby="offcanvasAddUserLabel">
        <div class="offcanvas-header border-bottom">
            <h6 id="offcanvasAddUserLabel" class="offcanvas-title">افزودن محصول جدید</h6>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                    aria-label="Close"></button>
        </div>
        <div class="offcanvas-body mx-0 flex-grow-0">
            <form class="add-new-user pt-0" id="addNewUserForm"
                  action="{{ route('admin.products.store') }}"
                  method="POST">
                @csrf
                <div class="mb-3">
                    <label class="form-label" for="name">نام</label>
                    <input type="text" class="form-control" id="name" name="name"
                           value="{{old('name')}}"
                           required>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="last_name">نام خانوادگی</label>
                    <input type="file" class="form-control" id="image" name="image"
                           value="{{ old('image') }}"
                           >
                </div>
                <button type="submit" class="btn btn-primary me-sm-3 me-1 data-submit">ثبت</button>
                <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="offcanvas">
                    انصراف
                </button>
            </form>
        </div>
    </div>

@endsection

@push('vendor')
    <script src="/assets/admin/vendor/libs/moment/moment.js"></script>
    <script src="/assets/admin/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
    <script src="/assets/admin/vendor/libs/datatables-bs5/i18n/fa.js"></script>
    <script src="/assets/admin/vendor/libs/select2/select2.js"></script>
    <script src="/assets/admin/vendor/libs/select2/i18n/fa.js"></script>
    <script src="/assets/admin/vendor/libs/formvalidation/dist/js/FormValidation.min.js"></script>
    <script src="/assets/admin/vendor/libs/formvalidation/dist/js/plugins/Bootstrap5.min.js"></script>
    <script src="/assets/admin/vendor/libs/formvalidation/dist/js/plugins/AutoFocus.min.js"></script>
    <script src="/assets/admin/vendor/libs/cleavejs/cleave.js"></script>
    <script src="/assets/admin/vendor/libs/cleavejs/cleave-phone.js"></script>
    <x-admin::deletemodalscript model="products"/>
@endpush
