@extends('admin::layouts.main')

@push('css')
    <link rel="stylesheet" href="/assets/admin/js/datepicker/persian-datepicker.min.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/typeahead-js/typeahead.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/select2/select2.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/tagify/tagify.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/bootstrap-select/bootstrap-select.css">
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row">
                <div class="col-md-8">
                    <h3>ویرایش محصول {{$product->name}}</h3>
                    <hr>
                    <div class="card mb-3">
                        <div class="card-header border-bottom">
                            <ul class="nav nav-tabs card-header-tabs primary-font" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" data-bs-toggle="tab"
                                            data-bs-target="#form-tabs-post"
                                            role="tab" aria-selected="false" tabindex="-1">
                                        جزئیات
                                    </button>
                                </li>
                            </ul>
                        </div>


                        <div class="tab-content">

                            <div class="tab-pane fade active show" id="form-tabs-post" role="tabpanel">
                                <form action="{{ route('admin.products.update' , $product) }}" method="post" id="edit-item">
                                    @method('patch')
                                    @csrf
                                    <div class="row g-3 mb-4">
                                        <div class="col-md-6">
                                            <label for="name" class="form-label">نام</label>
                                            <input type="text" name="name" class="form-control" value="{{$product->name}}" required>
                                        </div>
                                    </div>
                                </form>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-md-4">

                    <div class="card mb-3 ps-3 p-3">
                        <div class="ps-3 p-3 d-flex align-items-center justify-content-between">
                            <h5>جزییات</h5>
                            <a href="{{route('admin.products.index')}}">بازگشت</a>

                        </div>
                        <hr>
                            <div class="pt-4 d-flex align-items-center justify-content-between">
                                <button type="submit" class="btn btn-sm btn-primary " form="edit-item">بروز رسانی
                                </button>
                                @can('delete-orders')
                                    <x-admin::deletebutton/>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal fade" id="delete-modal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-sm">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="text-center mb-4 mt-0 mt-md-n2">
                            <h3 class="secondary-font">آیا اطمینان دارید؟</h3>
                        </div>
                        <form id="deleteForm" action="{{ route("admin.products.destroy", $product) }}"
                              method="POST">
                            @csrf
                            @method('DELETE')
                            <div class="col-12 text-center mt-4">
                                <button type="submit" class="btn btn-danger me-sm-3 me-1">حذف</button>
                                <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
                                        aria-label="Close">
                                    انصراف
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('vendor')
    <script src="/assets/admin/vendor/libs/select2/select2.js"></script>
    <script src="/assets/admin/vendor/libs/tagify/tagify.js"></script>
    <script src="/assets/admin/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
    <script src="/assets/admin/js/datepicker/persian-date.min.js"></script>
    <script src="/assets/admin/js/datepicker/persian-datepicker.min.js"></script>
    <script src="/assets/admin/js/forms-selects.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            const adminPrefix = $("meta[name='admin-prefix']").attr("content");
            $("#userId").select2({
                ajax: {
                    url: `/${adminPrefix}/users/search`,
                    dataType: 'json',
                    data: function (params) {
                        return {
                            search: params.term,
                        }
                    },
                    cache: true,
                    processResults: function (data) {
                        console.log(data)
                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.title }
                            })
                        }
                    }
                }
            })
            $(".date-picker").persianDatepicker({
                initialValue: true,
                format: 'YYYY/MM/DD HH:mm:ss',
                // minDate: new persianDate(),
                timePicker: {
                    enabled: true,
                    meridian: {
                        enabled: false,
                    },
                },
            });
        });
    </script>
@endpush
