<?php

namespace Modules\Product\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Modules\Product\Models\Product;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $search = request('search');
        $products = Product::query();
        if ($search) {
            $products = $products->where('name', 'like', '%' . $search . '%');
        }

        $products = $products->paginate(50);

        return view('product::admin.index', compact([
            'products',
            'search'
        ]));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('product::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $validData = $request->validate([
                'name' => 'required',
                'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
            Product::create($validData);
            alert()->success('موفق', 'محصول با موفقیت ساخته شد');
            return back();
        } catch (\Exception $exception) {
            alert()->error($exception->getMessage());
            return back();
        }
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('product::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Product $product)
    {
        return view('product::admin.edit', compact('product'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Product $product)
    {
        try {
            $validData = $request->validate([
                'name' => 'required',
            ]);

            $product->update($validData);

            alert()->success('موفق', 'محصول با موفقیت ویرایش شد');

            return back();
        }catch (\Exception $exception){
            alert()->error($exception->getMessage());
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Product $product)
    {
        Gate::authorize('delete-products');
        try {

            $product->delete();

            alert()->success('موفق', 'محصول با موفقیت حذف شد');

            return redirect(route('admin.products.index'));
        } catch (\Throwable $th) {
            alert()->error("خطا", $th->getMessage());
            return back();
        }
    }
}
