@extends('front::layouts.master')

@section('content')
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-4">
            <a href="#" class="app-brand-link gap-2 d-flex align-items-center justify-content-center my-3">
                <img src="/assets/admin/img/branding/logo.png" width="100px">
            </a>
            <!-- Register -->
            <div class="card" id="login">
                <div class="card">

                    <h5 class="card-header heading-color text-center">فرم ثبت سفارش</h5>
                    <div class="card-body">
                        <form id="order-submit" action="{{route('orders.store')}}"
                              class="row g-3 mb-3"
                              method="post" novalidate="novalidate" enctype="multipart/form-data">
                            @csrf
                            @method('post')
                            <!-- Account Details -->

                            <div class="col-12">
                                <h6 class="fw-normal">1. اطلاعات فردی و آدرس</h6>
                                <hr class="mt-0 mb-2">
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="name">نام </label>
                                <input type="text" id="name" class="form-control"
                                       placeholder="لطفا نام خود را وارد کنید"
                                       value="{{old('name')}}"
                                       name="name" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="lastname">نام خانوادگی </label>
                                <input type="text" id="lastname" class="form-control"
                                       placeholder="لطفا نام خانوادگی خود را وارد کنید"
                                       value="{{old('lastname')}}"
                                       name="lastname" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="phone">موبایل</label>
                                <input type="text" id="phone" class="form-control"
                                       placeholder="لطفا موبایل خود را وارد کنید"
                                       value="{{old('phone')}}"
                                       name="phone" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="instagram_id">آیدی اینستاگرام</label>
                                <input type="text" id="instagram_id" class="form-control"
                                       value="{{old('instagram_id')}}"
                                       placeholder="لطفا آیدی اینستاگرام خود را وارد کنید"
                                       name="instagram_id" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="postal_code">کد پستی</label>
                                <input type="text" id="postal_code" class="form-control"
                                       placeholder="لطفا کد پستی خود را وارد کنید"
                                       value="{{old('postal_code')}}"
                                       name="postal_code" required>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="address">آدرس</label>
                                <textarea class="form-control" placeholder="لطفا آدرس خود را وارد کنید" name="address"
                                          id="address" cols="30" rows="5">{{old('address')}}</textarea>
                            </div>


                            <!-- Personal Info -->

                            <div class="col-12">
                                <h6 class="mt-4 fw-normal">2. انتخاب محصول</h6>
                                <hr class="mt-0 mb-2">
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="address">انتخاب محصول (امکان انتخاب چند محصول همزمان وجود دارد)</label>
                                <select id="products" class="select2 form-select"
                                        name="products[]" multiple="multiple" required>
                                    @foreach(\Modules\Product\Models\Product::all() as $product)
                                        <option
                                            value="{{ $product->id }}" {{in_array($product->id, old('products') ?: []) ? 'selected' : ''}}>{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-12">
                                <h6 class="mt-4 fw-normal">3. آپلود فیش</h6>
                                <hr class="mt-0 mb-2">
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label" for="address">آپلود فیش پرداختی</label>
                                <input type="file" name="payment_image" id="payment_image" value="{{old('payment_image')}}" class="form-control ">
                            </div>


                            <!-- Choose Your Plan -->
                            <button type="submit" class="btn btn-primary">ثبت سفارش</button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /Register -->

        </div>
    </div>
@stop

@section('footer')
    <script src="/assets/admin/vendor/libs/select2/select2.js"></script>
    <script src="/assets/front/order.js"></script>
    <script>
        $('.select2').select2();
    </script>
@endsection
