@extends('admin::layouts.main')

@push('css')
    <link rel="stylesheet" href="/assets/admin/js/datepicker/persian-datepicker.min.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/typeahead-js/typeahead.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/select2/select2.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/tagify/tagify.css">
    <link rel="stylesheet" href="/assets/admin/vendor/libs/bootstrap-select/bootstrap-select.css">
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row">
                <div class="col-md-8">
                    <h3>ویرایش سفارش {{$order->id}}#</h3>
                    <hr>
                    <div class="card mb-3">
                        <div class="card-header border-bottom">
                            <ul class="nav nav-tabs card-header-tabs primary-font" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" data-bs-toggle="tab"
                                            data-bs-target="#form-tabs-post"
                                            role="tab" aria-selected="false" tabindex="-1">
                                        جزئیات
                                    </button>
                                </li>
                            </ul>
                        </div>


                        <div class="tab-content">

                            <div class="tab-pane fade active show" id="form-tabs-post" role="tabpanel">
                                <form action="{{ route('admin.orders.update' , $order) }}" method="post" id="edit-item">
                                    @method('patch')
                                    @csrf
                                    <div class="row g-3 mb-4">
                                        <div class="col-md-6">
                                            <label class="form-label" for="created_at">تاریخ سفارش</label>
                                            <input type="text" class="date-picker form-control" name="created_at"
                                                   autocomplete="off"
                                                   value="{{$order->created_at ?? old('created_at')}}">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="userId" class="form-label">موبایل کاربر</label>
                                            <select name="user_id" id="userId" class="form-select select2" required>
                                                <option value="{{$order->user->id}}">{{$order->user->phone . ' | ' . $order->user->name . ' ' . $order->user->lastname}}</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="select2Primary" class="form-label">محصولات</label>
                                            <div class="select2-primary">
                                                <select id="select2Primary" class="select2 form-select"
                                                        name="products[]" multiple required>
                                                    @foreach(\Modules\Product\Models\Product::all() as $product)
                                                        <option
                                                            value="{{ $product->id }}" {{$order->products->contains($product) ? 'selected' : ''}}>{{ $product->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-md-4">

                    <div class="card mb-3">
                        <div class="ps-3 p-3 d-flex align-items-center justify-content-between">
                            <h5>جزییات</h5>
                            <a href="{{route('admin.orders.index')}}">بازگشت</a>

                        </div>
                        <hr>
                        <div class="ps-3 p-3 ">
                            <ul>
                                 <li>
                                    <p class="m-0">
                                        <strong>نام و نام خانوادگی:</strong>
                                        {{$order->user->name . ' ' . $order->user->lastname}}
                                    </p>
                                </li>

                                <li>
                                      <p class="m-0">
                                        <strong>موبایل: </strong>
                                        {{$order->user->phone}}
                                    </p>
                                </li>
                                
                                <li>
                                    <p class="m-0">
                                        <strong>آدرس:</strong>
                                        {{$order->address}}
                                    </p>
                                </li>

                                <li>

                                      <p class="m-0">
                                        <strong>کد پستی:</strong>
                                        {{$order->postal_code}}
                                    </p>
                                </li>

                                <li>
                                      <p class="m-0">
                                        <strong>آیدی ایسنتاگرام:</strong>
                                        {{$order->instagram_id}}
                                    </p>
                                </li>
                                
                                <li>
                                     <strong>محصولات:</strong>
                                       @foreach($order->products()->get() as $product)
                                         "{{ $product->name }}",
                                        @endforeach
                                </li>
                            </ul>


                        </div>
                        <div class="ps-3 p-3 ">
                            <button type="button" class="btn btn-success w-100" data-bs-toggle="modal" data-bs-target="#modalCenter">
                                فیش پرداختی
                            </button>
                        </div>
                        <div class="ps-3 p-3">

                            <div class="mb-3">
                                <label class="form-label" for="status">وضعیت سفارش</label>
                                <select class="form-select" name="status" id="status"
                                        form="edit-item" required>
                                    <option value="">انتخاب کنید</option>
                                    <option value="completed" {{$order->status == 'completed' ? 'selected' : ''}}>تکمیل
                                        شده
                                    </option>
                                    <option value="pending" {{$order->status == 'pending' ? 'selected' : ''}}>در حال
                                        انجام
                                    </option>
                                </select>
                            </div>


                            <div class="modal fade" id="modalCenter" tabindex="-1" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title secondary-font" id="modalCenterTitle">فیش پرداختی</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <img src="{{$order->payment_image}}" width="100%" alt="">
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                                                بستن
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pt-4 d-flex align-items-center justify-content-between">
                                <button type="submit" class="btn btn-sm btn-primary " form="edit-item">بروز رسانی
                                </button>
                                @can('delete-orders')
                                    <x-admin::deletebutton/>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal fade" id="delete-modal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-sm">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="text-center mb-4 mt-0 mt-md-n2">
                            <h3 class="secondary-font">آیا اطمینان دارید؟</h3>
                        </div>
                        <form id="deleteForm" action="{{ route("admin.orders.destroy", $order) }}"
                              method="POST">
                            @csrf
                            @method('DELETE')
                            <div class="col-12 text-center mt-4">
                                <button type="submit" class="btn btn-danger me-sm-3 me-1">حذف</button>
                                <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
                                        aria-label="Close">
                                    انصراف
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('vendor')
    <script src="/assets/admin/vendor/libs/select2/select2.js"></script>
    <script src="/assets/admin/vendor/libs/tagify/tagify.js"></script>
    <script src="/assets/admin/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
    <script src="/assets/admin/js/datepicker/persian-date.min.js"></script>
    <script src="/assets/admin/js/datepicker/persian-datepicker.min.js"></script>
    <script src="/assets/admin/js/forms-selects.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            const adminPrefix = $("meta[name='admin-prefix']").attr("content");
            $("#userId").select2({
                ajax: {
                    url: `/${adminPrefix}/users/search`,
                    dataType: 'json',
                    data: function (params) {
                        return {
                            search: params.term,
                        }
                    },
                    cache: true,
                    processResults: function (data) {
                        console.log(data)
                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.title }
                            })
                        }
                    }
                }
            })
            $(".date-picker").persianDatepicker({
                initialValue: true,
                format: 'YYYY/MM/DD HH:mm:ss',
                // minDate: new persianDate(),
                timePicker: {
                    enabled: true,
                    meridian: {
                        enabled: false,
                    },
                },
            });
        });
    </script>
@endpush
