<?php

namespace Modules\Order\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Modules\Order\Models\Order;
use Modules\User\Models\User;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('order::front.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('order::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request) {
        try {
            $validData = $request->validate([
                'name' => 'required',
                'lastname' => 'required',
                'phone' => 'required',
                'instagram_id' => 'required',
                'postal_code' => 'required',
                'address' => 'required',
                'products' => 'required',
                'payment_image' => 'required',
            ]);

            $imageName = time().'.'.$request->payment_image->extension();
            $request->payment_image->move(public_path('images'), $imageName);

            // URL to access the image
            $imageUrl = url('images/'.$imageName);

            if (substr($validData['phone'],0 , 1) != 0) {
                $validData['phone'] = 0 . $validData['phone'];
            }

            $user = User::where('phone' , $validData['phone'])->first();

            if (!$user) {
                $user = User::create([
                    'name' => $validData['name'],
                    'lastname' => $validData['lastname'],
                    'phone' => $validData['phone'],
                ]);

                $user->assignRole('customer');
            }
            $order = $user->orders()->create([
                'postal_code' => $validData['postal_code'],
                'address' => $validData['address'],
                'instagram_id' => $validData['instagram_id'],
                'payment_image' => $imageUrl,
            ]);

            $order->products()->attach($validData['products']);

            alert()->success('موفق' , 'سفارش شما با موفقیت ثبت شد');
            return back();
        }catch (\Exception $e) {
            toast($e->getMessage(), 'error');
            return redirect()->back();
        }
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('order::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        return view('order::edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id) {}

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id) {}
}
