<?php

namespace Modules\Order\Http\Controllers\Admin;

use App\Exports\OrdersExport;
use App\Http\Controllers\Controller;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Order\Models\Order;
use Modules\Product\Models\Product;

class OrderController extends Controller
{
    use SEOTools;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        Gate::authorize('view-orders');

        $this->seo()->setTitle('سفارش ها');
        try {
            $sort_by = request('sort_by', 'created_at');
            $sort_direction = request('sort_direction', 'desc');
            $status = request('status', 'all');
            $count = request('count', 50);
            $export = request('export', false);

            $orders = Order::query();

            if ($status !== 'all') {
                $orders = $orders->where('status', $status);
            }

            $orders = $orders->orderBy($sort_by, $sort_direction);

//            if($export) {
//                ini_set('memory_limit', '-1');
//                return Excel::download(new OrdersExport($orders->get()), 'orders.xlsx');
//            }

            $orders = $orders->paginate($count)->withQueryString();

            return view('order::admin.index', compact(
                'orders',
                'sort_by',
                'sort_direction',
                'status',
                'count',
            ));
        } catch (\Throwable $th) {
            alert()->error("خطا", $th->getMessage());
            return back();
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('order::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request) {}

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('order::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Order $order)
    {
        return view('order::admin.edit', compact('order'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Order $order)
    {
        Gate::authorize('edit-orders');
        $validData = request()->validate([
            'status' => 'required',
            'products' => 'required',
        ]);

        try {

            $order->update(['status' => $validData['status']]);
            $order->products()->sync($validData['products']);
            alert()->success('موفق', 'سفارش با موفقیت ویرایش شد');

            return back();
        } catch (\Throwable $th) {
            alert()->error("خطا", $th->getMessage());
            return back();
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Order $order) {
        Gate::authorize('delete-orders');
        try {

            $order->delete();

            alert()->success('موفق', 'سفارش با موفقیت حذف شد');

            return redirect(route('admin.orders.index'));
        } catch (\Throwable $th) {
            alert()->error("خطا", $th->getMessage());
            return back();
        }
    }
}
