<?php

namespace Modules\Auth\Providers;

use App\Http\Middleware\Guest;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'Auth';
    protected string $moduleNamespace = 'Modules\Auth\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapAdminRoutes();
        $this->mapWebRoutes();
        $this->mapApiRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware(['web', 'guest'])
            ->namespace($this->moduleNamespace)
            ->group(module_path('Auth', 'routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware('web')
            ->namespace($this->moduleNamespace . '\admin')
            ->prefix(config('services.admin.prefix'))
            ->name('admin.')
            ->group(module_path('Auth', 'routes/admin.php'));
    }

    protected function mapApiRoutes(): void
    {
        Route::prefix(config('services.api.prefix'))
            ->middleware('api')
            ->namespace($this->moduleNamespace . '\api')
            ->group(module_path('Auth', 'routes/api.php'));
    }
}
