<?php

namespace Modules\Auth\Notifications;

use App\Broadcasting\SMSPanel;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Modules\Auth\Notifications\channel\VerifySms;

class OtpNotification extends Notification
{
    use Queueable;

    protected $phone;
    protected $code;

    public function __construct($phone, $code)
    {
        $this->phone = $phone;
        $this->code = $code;
    }
    public function via($notifiable): array
    {
        return [SMSPanel::class];
    }

    public function toSms($notifiable): array
    {
        return [
            'template_id' => 488033,
            'phone' => $this->phone,
            'code' => $this->code,
        ];
    }
}
