<?php

use Illuminate\Support\Facades\Route;
use Modules\Admin\Http\Controllers\AdminController;
use Modules\Admin\Http\Controllers\SettingsController;
use Illuminate\Support\Facades\Artisan;

Route::controller(AdminController::class)->group(function () {
    Route::get('/', 'index')->name('index');
});

Route::controller(SettingsController::class)->name('settings.')->prefix('/settings')->group(function () {
    Route::get('/', 'index')->name('index');
    Route::post('/maintenance', 'maintenance')->name('maintenance');
});

Route::get('/settings/clear-and-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    Artisan::call('config:clear');

    Artisan::call('config:cache');
    // Artisan::call('route:cache');
    Artisan::call('view:cache');

    toast()->success('کش با موفقیت پاک شد و فایل جدید کش شد');
    return back();

 })->name('settings.cache');
