@extends('admin::layouts.main')
@push('css')
<link href="{{asset('assets/vendor/sweetalert/sweetalert2.css')}}"></link>
@endpush
@section('content')
    <div class="content-wrapper">
        <div class="flex-grow-1 p-3y">
            <h3 class="ms-4">تنظیمات سایت</h3>
            <div class="card mx-4">
                @if(auth()->user()->hasRole('super-admin'))
                    <div class="col-md-2 mb-4 mx-4">
                        <h3>حالت تعمیر</h3>
                        <form id="maintenance" action="{{ route('admin.settings.maintenance') }}" method="POST">
                            @csrf
                            <button type="submit" form="maintenance" class="btn btn-danger mt-4">
                                @if(app()->isDownForMaintenance())
                                    غیر فعال کردن
                                @else
                                    فعال کردن
                                @endif
                                حالت تعمیر
                            </button>
                        </form>

                        @if(app()->isDownForMaintenance())
                        @php
                            $cookie = json_decode(file_get_contents(storage_path('framework/down')), true)['secret'];
                        @endphp
                        <a class="btn btn-primary mt-4" href="/{{ $cookie }}">رفتن به سایت در حالت تعمیر</a>
                        @endif
                    </div>
                @endif

                <div class="col-md-2 mb-4 mx-4">
                        <h3>کش وبسایت</h3>
                        <a href="{{ route('admin.settings.cache') }}" class="btn btn-warning">پاک کردن و کانفیگ کش</a>
            </div>
        </div>
        <div class="content-backdrop fade"></div>
    </div>
@endsection
