<?php

namespace Modules\Admin\Http\Controllers;

use App\Http\Controllers\Controller;
use Artisan;

class SettingsController extends Controller
{
    private function gate()
    {
        if(auth()->user()->role() != 'super-admin') abort(403);
    }

    public function index()
    {
        $this->gate();
        return view('admin::settings.index');
    }

    public function maintenance()
    {
        $this->gate();

        if(app()->isDownForMaintenance()) {
            Artisan::call('up');
        } else {
            Artisan::call('down --with-secret');
        }
        return back();
    }
}
