<?php
/**
 * Developer : MahdiY
 * Web Site  : MahdiY.IR
 * E-Mail    : M@hdiY.IR
 */

defined( 'ABSPATH' ) || exit;

class PWS_Status {

	public static $status = [
		2 => 'wc-pws-ready-to-ship',

		1 => 'wc-pws-packaged',

		10  => 'wc-pws-returned',
		11  => 'wc-pws-returned',
		83  => 'wc-pws-returned',
		102 => 'wc-pws-returned',

		7  => 'wc-completed',
		70 => 'wc-completed',
		71 => 'wc-completed',
		72 => 'wc-completed',

		80 => 'wc-pws-deleted',

		5  => 'wc-pws-shipping',
		8  => 'wc-pws-shipping',
		13 => 'wc-pws-shipping',
		14 => 'wc-pws-shipping',
		15 => 'wc-pws-shipping',
		16 => 'wc-pws-shipping',
		17 => 'wc-pws-shipping',
		50 => 'wc-pws-shipping',

		3  => 'wc-pws-need-review',
		4  => 'wc-pws-need-review',
		6  => 'wc-pws-need-review',
		9  => 'wc-pws-need-review',
		12 => 'wc-pws-need-review',
		81 => 'wc-pws-need-review',
		82 => 'wc-pws-need-review',
		18 => 'wc-pws-need-review',
	];

	public function __construct() {
		add_action( 'init', [ $this, 'register_order_statuses' ] );
		add_filter( 'wc_order_statuses', [ $this, 'add_order_statuses' ], 10, 1 );
		add_filter( 'woocommerce_reports_order_statuses', [ $this, 'reports_statuses' ], 10, 1 );
		add_filter( 'woocommerce_order_is_paid_statuses', [ $this, 'paid_statuses' ], 10, 1 );
		add_filter( 'bulk_actions-edit-shop_order', [ $this, 'bulk_actions' ], 20, 1 );

		if ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'persian-woocommerce-shipping-dokan/pws-dokan.php' ) ) {
			return;
		}

		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

		if ( PWS_Tapin::is_enable() ) {
			add_action( 'add_meta_boxes', [ $this, 'order_meta_box' ] );
			add_action( 'save_post', [ $this, 'save_order_meta_box' ], 1000, 3 );
			add_action( 'manage_posts_extra_tablenav', [ $this, 'top_order_list' ], 20, 1 );
			add_action( 'wp_ajax_pws_change_order_status', [ $this, 'change_status_callback' ] );
			add_action( 'wp', [ $this, 'check_status_scheduled' ] );
			add_action( 'pws_check_status', [ $this, 'check_status_callback' ] );
		}
	}

	public static function get_statues(): array {

		$statuses = [];

		if ( PWS()->get_option( 'tools.status_enable' ) == 1 ) {

			$statuses['wc-pws-in-stock'] = __( 'ارسال شده به انبار' );
			$statuses['wc-pws-packaged'] = __( 'بسته بندی شده' );
			$statuses['wc-pws-courier']  = __( 'تحویل پیک' );
			$statuses['wc-pws-post']     = __( 'تحویل پست' );

		}

		if ( PWS_Tapin::is_enable() ) {
			$statuses['wc-pws-packaged']      = __( 'بسته بندی شده' );
			$statuses['wc-pws-ready-to-ship'] = __( 'آماده به ارسال' );
			$statuses['wc-pws-returned']      = __( 'برگشتی' );
			$statuses['wc-pws-deleted']       = __( 'حذف شده' );
			$statuses['wc-pws-shipping']      = __( 'در حال ارسال' );
			$statuses['wc-pws-need-review']   = __( 'نیازمند بررسی' );
		}

		return apply_filters( 'pws_get_order_statuses', $statuses );
	}

	public function register_order_statuses() {

		foreach ( $this->get_statues() as $status => $label ) {
			register_post_status( $status, [
				'label'                     => $label,
				'public'                    => false,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				'label_count'               => _n_noop( $label . ' <span class="count">(%s)</span>', $label . ' <span class="count">(%s)</span>' ),
			] );
		}

	}

	public function add_order_statuses( $order_statuses ): array {
		$new_order_statuses = [];

		foreach ( $order_statuses as $key => $status ) {
			$new_order_statuses[ $key ] = $status;

			if ( 'wc-processing' === $key ) {

				foreach ( $this->get_statues() as $status => $label ) {
					$new_order_statuses[ $status ] = $label;
				}

			}
		}

		return $new_order_statuses;
	}

	public function reports_statuses( $order_status ) {

		$dont_report = [
			'wc-pws-returned',
			'wc-pws-deleted',
		];

		foreach ( $this->get_statues() as $status => $label ) {
			if ( ! in_array( $status, $dont_report ) ) {
				$order_status[] = str_replace( 'wc-', '', $status );
			}
		}

		return $order_status;
	}

	public function paid_statuses( $order_status ) {

		$dont_paid = [
			'wc-pws-returned',
			'wc-pws-deleted',
		];

		foreach ( $this->get_statues() as $status => $label ) {
			if ( ! in_array( $status, $dont_paid ) ) {
				$order_status[] = str_replace( 'wc-', '', $status );
			}
		}

		return $order_status;
	}

	public function bulk_actions( $actions ) {

		foreach ( $this->get_statues() as $status => $label ) {
			$key                       = str_replace( 'wc-', '', $status );
			$actions[ 'mark_' . $key ] = 'تغییر وضعیت به ' . $label;
		}

		return $actions;
	}

	public function enqueue_scripts() {

		wp_enqueue_style( 'pws_order_status', PWS_URL . 'assets/css/status.css' );

		if ( ! PWS_Tapin::is_enable() ) {
			return;
		}

		$screen = get_current_screen();

		if ( $screen->id == 'edit-shop_order' ) {
			wp_enqueue_script( 'pws_tapin_list', PWS_URL . 'assets/js/tapin-list.js' );
		}

		if ( $screen->id == 'shop_order' ) {
			wp_enqueue_script( 'pws_tapin_list', PWS_URL . 'assets/js/tapin-order.js' );
		}
	}

	public function top_order_list( $which ) {
		global $typenow;

		if ( 'shop_order' === $typenow && 'top' === $which ) {
			?>
			<div class="alignleft actions custom">
				<button type="button" id="pws-tapin-submit" class="button-primary"
						title="جهت ثبت سفارشات انتخاب شده در پنل تاپین و دریافت بارکد پستی، کلیک کنید.">ثبت در تاپین
				</button>
				<button type="button" id="pws-tapin-ship" class="button-primary"
						title="پس از ثبت سفارش در پنل، جهت اعلام به پست برای جمع آوری بسته اینجا کلیک کنید.">آماده ارسال
				</button>
			</div>
			<?php
		}
	}

	public function order_meta_box() {
		add_meta_box( 'tapin_order', 'تاپین', [ $this, 'order_meta_box_callback' ], 'shop_order', 'side' );
	}

	public function order_meta_box_callback( $post, $args ) {

		/** @var WC_Order $order */
		$order = wc_get_order( $post->ID );

		$order_uuid   = $order->get_meta( 'tapin_order_uuid' );
		$tapin_weight = PWS_Order::get_weight( $order );

		$content_type = $order->get_meta( 'tapin_content_type' );

		if ( empty( $content_type ) ) {
			$content_type = PWS()->get_option( 'tapin.content_type', 4 );
		}

		$shipping_method = PWS_Order::get_shipping_method( $order )

		?>

		<?php if ( empty( $order_uuid ) ) { ?>

			<p class="form-field-wide">
				<label for="tapin_weight">وزن سفارش:</label>
				<input type="number" name="tapin_weight" id="tapin_weight" style="width: 100%"
					   value="<?php echo intval( $tapin_weight ); ?>">
			</p>

			<p class="form-field-wide">
				<label>نوع مرسوله:</label>
				<select style="width: 100%" name="tapin_content_type" id="tapin_content_type">
					<option value="1" <?php selected( 1, $content_type ); ?>>عادی</option>
					<option value="2" <?php selected( 2, $content_type ); ?>>شکستنی</option>
					<option value="3" <?php selected( 3, $content_type ); ?>>مایعات</option>
					<option value="4" <?php selected( 4, $content_type ); ?>>غیراستاندارد</option>
				</select>
			</p>

			<button type="button" id="pws-tapin-submit" class="button-primary"
					title="جهت ثبت سفارشات انتخاب شده در پنل تاپین و دریافت بارکد پستی، کلیک کنید.">ثبت در تاپین
			</button>
		<?php } else { ?>

			<p class="form-field-wide">
				<label>وزن سفارش:</label>
				<input type="number" style="width: 100%"
					   value="<?php echo intval( $tapin_weight ); ?>" disabled="disabled">
			</p>

			<p class="form-field-wide">
				<label>نوع پست:</label>
				<select style="width: 100%" disabled="disabled">
					<option value="" <?php selected( null, $shipping_method ); ?>>غیرپستی</option>
					<option value="0" <?php selected( 0, $shipping_method ); ?>>پست سفارشی</option>
					<option value="1" <?php selected( 1, $shipping_method ); ?>>پست پیشتاز</option>
				</select>
			</p>

			<p class="form-field-wide">
				<label>نوع مرسوله:</label>
				<select style="width: 100%" disabled="disabled">
					<option value="1" <?php selected( 1, $content_type ); ?>>عادی</option>
					<option value="2" <?php selected( 2, $content_type ); ?>>شکستنی</option>
					<option value="3" <?php selected( 3, $content_type ); ?>>مایعات</option>
					<option value="4" <?php selected( 4, $content_type ); ?>>غیراستاندارد</option>
				</select>
			</p>

			<button type="button" id="pws-tapin-ship" class="button-primary"
					title="پس از ثبت سفارش در پنل، جهت اعلام به پست برای جمع آوری بسته اینجا کلیک کنید.">آماده ارسال
			</button>
			<?php
		}

		?>
		<div class="pws-tips" style="margin-top: 15px;"></div>
		<?php
	}

	public function save_order_meta_box( $order_id, $post, $update ) {

		$order_uuid = get_post_meta( $order_id, 'tapin_order_uuid', true );

		if ( ! empty( $order_uuid ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( get_post_status( $order_id ) === 'auto-draft' ) {
			return;
		}

		if ( ! isset( $_POST['tapin_weight'], $_POST['tapin_content_type'] ) ) {
			return;
		}

		update_post_meta( $order_id, 'tapin_weight', floatval( $_POST['tapin_weight'] ) );
		update_post_meta( $order_id, 'tapin_content_type', intval( $_POST['tapin_content_type'] ) );
	}

	public function change_status_callback() {

		if ( ! current_user_can( 'edit_shop_orders' ) ) {
			wp_die( - 1 );
		}

		$status = sanitize_text_field( $_POST['status'] ?? null );

		if ( ! wc_is_order_status( 'wc-' . $status ) ) {

			echo json_encode( [
				'success' => false,
				'message' => 'وضعیت انتخاب شده معتبر نمی باشد.',
			] );

			die();
		}

		$order_id = intval( $_POST['id'] ?? null );

		if ( empty( $order_id ) ) {

			echo json_encode( [
				'success' => false,
				'message' => 'سفارش انتخاب شده معتبر نمی باشد.',
			] );

			die();
		}

		/** @var WC_Order $order */
		$order = wc_get_order( $order_id );

		if ( $order == false ) {

			echo json_encode( [
				'success' => false,
				'message' => 'سفارش انتخاب شده وجود ندارد.',
			] );

			die();
		}

		if ( isset( $_POST['weight'] ) ) {
			$order->add_meta_data( 'tapin_weight', floatval( $_POST['weight'] ), true );
			$order->save_meta_data();
		}

		if ( isset( $_POST['content_type'] ) ) {
			$order->add_meta_data( 'tapin_content_type', intval( $_POST['content_type'] ), true );
			$order->save_meta_data();
		}

		$tapin_post_type = PWS_Order::get_shipping_method( $order );

		if ( is_null( $tapin_post_type ) ) {

			echo json_encode( [
				'success' => false,
				'message' => 'روش ارسال این سفارش تاپین نیست.',
			] );

			die();
		}

		$tapin_order_uuid = get_post_meta( $order_id, 'tapin_order_uuid', true );

		if ( $status == 'pws-packaged' ) { // Submit & get post barcode

			if ( ! empty( $tapin_order_uuid ) ) {

				echo json_encode( [
					'success' => false,
					'message' => 'این سفارش قبلا در پنل ثبت شده است.',
				] );

				die();
			}

			$products = [];

			foreach ( $order->get_items() as $order_item ) {

				/** @var WC_Product $product */
				$product = $order_item->get_product();

				if ( $product && $product->is_virtual() ) {
					continue;
				}

				$price = ( $order_item->get_total() + $order_item->get_total_tax() ) / $order_item->get_quantity();
				$price = ceil( $price );

				if ( get_woocommerce_currency() == 'IRT' ) {
					$price *= 10;
				}

				if ( get_woocommerce_currency() == 'IRHR' ) {
					$price *= 1000;
				}

				if ( get_woocommerce_currency() == 'IRHT' ) {
					$price *= 10000;
				}

				$title = trim( PWS()->get_option( 'tapin.product_title' ) );

				if ( empty( $title ) ) {
					$title = $order_item->get_name();
				}

				if ( function_exists( 'mb_substr' ) ) {
					$title = mb_substr( $title, 0, 50 );
				}

				$products[] = [
					'count'      => $order_item->get_quantity(),
					'discount'   => 0,
					'price'      => intval( $price ),
					'title'      => $title,
					'weight'     => 0,
					'product_id' => null,
				];
			}

			$order_weight = PWS_Order::get_weight( $order );

			$tapin_content_type = $order->get_meta( 'tapin_content_type' );

			if ( empty( $tapin_content_type ) ) {
				$tapin_content_type = PWS()->get_option( 'tapin.content_type', 4 );
			}

			$tapin_pay_type = 1;

			if ( $order->get_payment_method() == 'cod' ) {

				if ( $order->get_shipping_total() ) {
					$tapin_pay_type = 0;

					$packaging_cost = $order->get_meta( 'packaging_cost' );

					if ( $packaging_cost ) {

						if ( $packaging_cost == $order->get_shipping_total() ) {
							$tapin_pay_type = 3;
						}

						if ( get_woocommerce_currency() == 'IRT' ) {
							$packaging_cost *= 10;
						}

						if ( get_woocommerce_currency() == 'IRHR' ) {
							$packaging_cost *= 1000;
						}

						if ( get_woocommerce_currency() == 'IRHT' ) {
							$packaging_cost *= 10000;
						}

						$products[] = [
							'count'      => 1,
							'discount'   => 0,
							'price'      => intval( $packaging_cost ),
							'title'      => 'بسته بندی',
							'weight'     => 0,
							'product_id' => null,
						];
					}

				} else {
					$tapin_pay_type = 3;
				}

			}

			if ( wc_ship_to_billing_address_only() ) {
				$address       = $order->get_billing_address_1() . ' ' . $order->get_billing_address_2();
				$city_code     = $order->get_meta( '_billing_city_id' );
				$province_code = $order->get_meta( '_billing_state_id' );
				$first_name    = $order->get_billing_first_name();
				$last_name     = $order->get_billing_last_name();
				$postcode      = $order->get_billing_postcode();
			} else {
				$address       = $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2();
				$city_code     = $order->get_meta( '_shipping_city_id' );
				$province_code = $order->get_meta( '_shipping_state_id' );
				$first_name    = $order->get_shipping_first_name();
				$last_name     = $order->get_shipping_last_name();
				$postcode      = $order->get_shipping_postcode();
			}

			$data = apply_filters( 'pws_tapin_submit_order', [
				'register_type'  => 1,
				'shop_id'        => PWS()->get_option( 'tapin.shop_id' ),
				'address'        => $address,
				'city_code'      => $city_code,
				'province_code'  => $province_code,
				'description'    => empty( $order->get_customer_note() ) ? null : $order->get_customer_note(),
				'email'          => null,
				'employee_code'  => '-1',
				'first_name'     => $first_name,
				'last_name'      => $last_name,
				'mobile'         => str_replace( [ '+98', '0098' ], '0', $order->get_billing_phone() ),
				'phone'          => null,
				'postal_code'    => $postcode,
				'pay_type'       => $tapin_pay_type,
				'order_type'     => $tapin_post_type,
				'content_type'   => $tapin_content_type,
				'package_weight' => $order_weight,
				'products'       => $products,
				'manual_id'      => $order_id,
			], $order );

			$data['presenter_code'] = 1025;

			PWS_Tapin::set_gateway( PWS()->get_option( 'tapin.gateway' ) );

			$response = PWS_Tapin::request( 'v2/public/order/post/register', $data );

			if ( is_wp_error( $response ) ) {

				echo json_encode( [
					'success' => false,
					'message' => implode( '<br>', $response->get_error_messages() ),
				] );

				die();

			} else if ( ! in_array( $response->returns->status, [ 200, 770 ] ) ) {

				PWS()->log( __METHOD__ . ' Line: ' . __LINE__ );
				PWS()->log( $data );
				PWS()->log( $response );

				$errors = [];

				foreach ( (array) $response->entries as $key => $message ) {
					if ( is_string( $message[0] ) ) {
						$errors[] = "{$key} > {$message[0]}";
					}
				}

				echo json_encode( [
					'success' => false,
					'message' => $response->returns->message . '<br>' . implode( '<br>', $errors ),
				] );

				die();
			}

			update_post_meta( $order_id, 'tapin_order_uuid', $response->entries->id );
			update_post_meta( $order_id, 'tapin_order_id', $response->entries->order_id );
			update_post_meta( $order_id, 'tapin_send_price', $response->entries->send_price );
			update_post_meta( $order_id, 'tapin_send_price_tax', $response->entries->send_price_tax );
			update_post_meta( $order_id, 'tapin_send_time', time() );
			update_post_meta( $order_id, 'tapin_weight', $order_weight );
			update_post_meta( $order_id, 'tapin_content_type', $tapin_content_type );
			update_post_meta( $order_id, 'post_barcode', $response->entries->barcode );

			$note = "بارکد پستی مرسوله شما: {$response->entries->barcode}
                        می توانید مرسوله خود را از طریق لینک https://radgir.net رهگیری نمایید.";

			$order->set_status( $status, 'تاپین -' );
			$order->save();
			$order->add_order_note( $note, 1 );

			do_action( 'pws_save_order_post_barcode', $order, $response->entries->barcode );

			echo json_encode( [
				'success' => true,
				'message' => 'بسته بندی شده',
			] );

			die();

		} else if ( $status == 'pws-ready-to-ship' ) {

			if ( empty( $tapin_order_uuid ) ) {

				echo json_encode( [
					'success' => false,
					'message' => 'سفارش در تاپین ثبت نشده است.',
				] );

				die();
			}

			$tapin_order_id = get_post_meta( $order_id, 'tapin_order_id', true );

			$data = [
				'shop_id'  => PWS()->get_option( 'tapin.shop_id' ),
				'order_id' => $tapin_order_id,
				'status'   => 2,
			];

			PWS_Tapin::set_gateway( PWS()->get_option( 'tapin.gateway' ) );

			$response = PWS_Tapin::request( 'v2/public/order/post/change-status', $data );

			if ( is_wp_error( $response ) ) {

				echo json_encode( [
					'success' => false,
					'message' => implode( '<br>', $response->get_error_messages() ),
				] );

				die();

			} else if ( $response->returns->status != 200 ) {

				PWS()->log( __METHOD__ . ' Line: ' . __LINE__ );
				PWS()->log( $data );
				PWS()->log( $response );

				$errors = [];

				foreach ( (array) $response->entries as $key => $message ) {
					if ( is_string( $message[0] ) ) {
						$errors[] = "{$key} > {$message[0]}";
					}
				}

				echo json_encode( [
					'success' => false,
					'message' => $response->returns->message . '<br>' . implode( '<br>', $errors ),
				] );

				die();
			}

			$order->set_status( $status, 'تاپین -' );
			$order->save();

			echo json_encode( [
				'success' => true,
				'message' => 'آماده به ارسال',
			] );

			die();

		} else {

			echo json_encode( [
				'success' => false,
				'message' => "ابتدا باید به 'بسته بندی شده' تغییر وضعیت دهید.",
			] );

			die();

		}

	}

	public function check_status_scheduled() {
		if ( ! wp_next_scheduled( 'pws_check_status' ) ) {
			wp_schedule_event( time(), 'hourly', 'pws_check_status' );
		}
	}

	public static function check_status_callback() {

		$args_query = apply_filters( 'pws_tapin_check_status_orders', [
			'post_type'      => [ 'shop_order' ],
			'post_status'    => [
				'wc-pws-packaged',
				'wc-pws-ready-to-ship',
				'wc-pws-shipping',
				'wc-pws-deleted',
				'wc-pws-need-review',
			],
			'posts_per_page' => 100,
			'orderby'        => 'rand',
			'meta_key'       => 'tapin_order_uuid',
		] );

		$query = new WP_Query( $args_query );

		$posts = array_column( $query->posts, 'ID' );

		$posts = array_map( function ( $post_id ) {
			return [
				'id'      => get_post_meta( $post_id, 'tapin_order_uuid', true ),
				'post_id' => $post_id,
			];
		}, $posts );
		$posts = array_filter( $posts, function ( $row ) {
			return ! empty( $row['id'] );
		} );

		if ( count( $posts ) == 0 ) {
			return false;
		}

		PWS_Tapin::set_gateway( PWS()->get_option( 'tapin.gateway' ) );

		$statuses = PWS_Tapin::request( 'v2/public/order/post/get-status/bulk', [
			'shop_id' => PWS()->get_option( 'tapin.shop_id' ),
			'orders'  => array_values( $posts ),
		] );

		if ( is_wp_error( $statuses ) || ! isset( $statuses->entries->list ) || ! is_array( $statuses->entries->list ) ) {
			return false;
		}

		$orders = array_column( $statuses->entries->list, null, 'id' );

		foreach ( $posts as $post ) {

			if ( ! isset( $orders[ $post['id'] ] ) ) {
				continue;
			}

			$status = $orders[ $post['id'] ]->status;

			$status = self::$status[ $status ] ?? null;

			if ( is_null( $status ) ) {
				continue;
			}

			/** @var WC_Order $order */
			$order = wc_get_order( $post['post_id'] );

			if ( $order->get_status() != $status ) {
				$order->set_status( $status, 'بروزرسانی خودکار تاپین -' );
				$order->save();
			}

		}

		wp_reset_postdata();
	}

}

new PWS_Status();
