# Copyright (C) 1998-2018 by the Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

"""Common routines for logging in and logging out of the list administrator
and list moderator interface.
"""
from __future__ import print_function

from Mailman import mm_cfg
from Mailman import Utils
from Mailman import Errors
from Mailman.htmlformat import FontAttr
from Mailman.i18n import _
import os


class NotLoggedInError(Exception):
    """Exception raised when no matching admin cookie was found."""
    def __init__(self, message):
        Exception.__init__(self, message)
        self.message = message



def loginpage(mlist, scriptname, msg='', frontpage=None):
    url = mlist.GetScriptURL(scriptname)
    if frontpage:
        actionurl = url
    else:
        actionurl = Utils.GetRequestURI(url)
    if msg:
        msg = FontAttr(msg, color='#ff0000', size='+1').Format()
        # give an HTTP 401 for authentication failure
        print('Status: 401 Unauthorized')
    if scriptname == 'admindb':
        who = _('Moderator')
    else:
        who = _('Administrator')
    # Language stuff
    charset = Utils.GetCharSet(mlist.preferred_language)
    is_cpanel = os.environ.get('CPANEL')
    if is_cpanel:
        cpanel_url = '../../../../mailman_service/' + scriptname + '/' + mlist.internal_name()
    else:
        cpanel_url = '/webmail/mailman_service/' + scriptname + '/' + mlist.internal_name()
    print('Content-type: text/html; charset=' + charset + '\n\n')
    print(Utils.maketext(
        'admlogin.html',
        {'listname': mlist.real_name,
         'scriptname': scriptname,
         'internal_name': mlist.internal_name(),
         'cpanel_url': cpanel_url,
         'path'    : actionurl,
         'message' : msg,
         'who'     : who,
         }, mlist=mlist))
    print(mlist.GetMailmanFooter())
