<?php
/**
 * Single Product Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
global $product;
?>

<div class="product-price-wrapper">

    <p class="<?php echo esc_attr(apply_filters('woocommerce_product_price_class', 'price')); ?>">
        <?php echo $product->get_price_html(); ?>
    </p>
<?php
if( $product->is_type( 'simple' ) ) {
    $stock_status = $product->get_stock_status();
    // available
    if ($stock_status == 'instock') {
        echo '<span class="stock in-stock">موجود</span>';

    } elseif ($stock_status == 'outofstock') {
        echo '<span class="stock out-stock">ناموجود</span>';
    }
} elseif( $product->is_type( 'variable' ) ){

}
?>
</div>
