<?php
/**
 * Sidebar
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/sidebar.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
?>
<div class="site-shop--sidebar--header d-flex d-lg-none">
    <span>فیلتر محصول</span>
    <div class="close-sidebar">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
             class="feather feather-x">
            <line x1="18" y1="6" x2="6" y2="18"></line>
            <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
    </div>
</div>
<?php if ((is_active_sidebar('sidebar-woocommerce-filter')) != '') : ?>
    <?php dynamic_sidebar('sidebar-woocommerce-filter'); ?>

    <?php $brand = get_terms(array(
        'taxonomy' => 'pa_a1',
        'hide_empty' => false,
    ));

//    print_r($brand);
    ?>
    <div id="nav_menu-3" class="widget widget-brand"><h4 class="widget-title">برندها</h4>
        <div class="brand-container">
            <ul class="product-categories">
                <?php foreach ($brand as $b) { ?>
                    <li class="">
                        <span class="prefix-parent-toggle"><i class="icon-down-arrow"></i></span><a
                                href="<?php echo get_term_link($b->term_id); ?>"><?php echo $b->name; ?></a>
                    </li>
                <?php } ?>
        </div>
    </div>
<?php endif; ?>
