<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class('product-single', $product); ?>>
    <?php get_template_part('templates/content/breadcrumb'); ?>

    <div class="product-single--columns row">
        <div class="col-12 col-md-6">
            <?php
            /**
             * Hook: woocommerce_before_single_product_summary.
             *
             * @hooked woocommerce_show_product_sale_flash - 10
             * @hooked woocommerce_show_product_images - 20
             */
            do_action('woocommerce_before_single_product_summary');
            ?>
        </div>
        <div class="col-12 col-md-6">
            <div class="summary entry-summary product-details">
                <?php
                /**
                 * Hook: woocommerce_single_product_summary.
                 *
                 * @hooked woocommerce_template_single_title - 5
                 * @hooked woocommerce_template_single_rating - 10
                 * @hooked woocommerce_template_single_price - 10
                 * @hooked woocommerce_template_single_excerpt - 20
                 * @hooked woocommerce_template_single_add_to_cart - 30
                 * @hooked woocommerce_template_single_meta - 40
                 * @hooked woocommerce_template_single_sharing - 50
                 * @hooked WC_Structured_Data::generate_product_data() - 60
                 */
                do_action('woocommerce_single_product_summary');
                ?>
            </div>
            <div class="product-actions">
                <?php
                echo do_shortcode('[ti_wishlists_addtowishlist]');

                echo '<div class="product-share">' . socialshares() . '</div>';
                ?>
            </div>
        </div>


        <?php
        if( have_rows('chart_acord') ): ?>
        <div class="col-12 col-lg-6">
            <div class="box-inner">
                <h3 class="box-inner-title mb-4">چارت آکوردها</h3>
                <?php while( have_rows('chart_acord') ) : the_row(); 
                $chart_title = get_sub_field('chart_aq');
                $aq_val  = $chart_title['value'];
                $sep_aq = explode(" - ", $aq_val);
                
                // $text_color = isColorLightOrDark($sep_aq[1]);
                $white_items = array("violet", "cacao", "patchouli", "animalic", "Cannabi", "camphor", "Amber" , "Smoky" , "Oud" , "Marine" , "Tobacco" , "Warm Spice" , "Green" , "coffee" , "Earthy" , "Woody" , "Leather" , "Sweet" , "Rose" , "Iris" , "Cinnamon" , "Cannabi" , "animalic" , "patchouli" , "Conifer");
                ?>
                <div class="progress">
<div class="progress-bar" role="progressbar" style="width: <?php the_sub_field('value'); ?>%; color: <?php echo in_array($sep_aq[0], $white_items) ? '#fff' : '#000'; ?>; background-color: <?php echo $sep_aq[1]; ?> " aria-valuenow="<?php the_sub_field('value'); ?>" aria-valuemin="0" aria-valuemax="100"><span><?php echo $chart_title['label']. ' - ' . $sep_aq[0]; ?></span></div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
        <?php endif; 
        if( have_rows('season') ):
        ?>
        <div class="col-12 col-lg-6">
            <div class="box-inner season-box">
                <h3 class="box-inner-title mb-4">مناسب ترین فصل و زمان</h3>
             <div class="row">
                 <?php while( have_rows('season') ) : the_row();
                    $season_title = get_sub_field('title');
                    switch ($season_title) {
                        case 'spring':
                            $title = 'بهار' ;
                            $bg_color = '#9fe584';
                            break;
                        case 'summer':
                            $title = 'تابستان' ;
                            $bg_color = '#fc958a';
                            break;
                        case 'winter':
                            $title = 'زمستان' ;
                            $bg_color = '#78d6f0';
                            break;
                        case 'fall':
                            $title = 'پاییز' ;
                            $bg_color = '#f9be6e';
                            break;
                        case 'day':
                            $title = 'روز' ;
                            $bg_color = '#fcf487';
                            break;
                        case 'night':
                            $title = 'شب' ;
                            $bg_color = '#447ba3';
                            break;
                    }
                 ?>
                 <div class="col-6 col-md-4">
                     <div class="season-card">
                         <span class="image-wrapper d-block mx-auto mb-2">
                             <img src="<?php echo get_template_directory_uri(); ?>/assets/images/<?php echo $season_title; ?>.svg" width="" height="" alt="<?php echo $season_title; ?>" />
                         </span>
                        <span class="title d-block"><?php echo $title; ?></span>
                        <div class="progress">
                          <div class="progress-bar" role="progressbar" style="width: <?php the_sub_field('bar_value'); ?>%; background-color: <?php echo $bg_color; ?>" aria-valuenow="<?php the_sub_field('bar_value'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                     </div>
                 </div>
                 <?php endwhile; ?>
             </div>
             </div>
        </div>
        <?php endif; ?>

        <?php if (get_field('video_embed') != '') { ?>
            <div class="col-12 video-wrap">
                <div class="video-inner">
                    <h3 class="video-title"><?php the_field('video_title'); ?></h3>
                    <?php if(get_field('video_embed')!=''): ?>
                    <div>
                        <?php echo get_field('video_embed'); ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php } ?>

        <?php
        /**
         * Hook: woocommerce_after_single_product_summary.
         *
         * @hooked woocommerce_output_product_data_tabs - 10
         * @hooked woocommerce_upsell_display - 15
         * @hooked woocommerce_output_related_products - 20
         */
        do_action('woocommerce_after_single_product_summary');
        ?>

    </div>
</div>

<?php do_action('woocommerce_after_single_product'); ?>
