<?php
$section_title = get_field('category_sec_title' , 'option');
$section_desc = get_field('category_sec_desc' , 'option');
?>
<section class="product-cats">
    <div class="container">
        <div class="row product-categories-row">
            <?php if ($section_title != '' || $section_desc != '') {
            echo '<div class="col-12 col-md-10 col-lg-6 mx-auto text-center">';
                if ($section_title != '') { echo '<h2 class="entry-title wow fadeInUp" data-wow-delay="0.25s">'.$section_title.'</h2>'; }
                if ($section_desc != '') { echo '<p class="entry-desc wow fadeInUp" data-wow-delay="0.5s">'.$section_desc.'</p>'; }
                echo '</div>';
             } ?>
            <?php
            $terms = get_terms([
                'taxonomy' => 'product_cat',
                'hide_empty' => true,
                'meta_query' => [
                    'key' => 'home_category',
                    'value' => 1
                ]
            ]);
            if ($terms) {
                ?>
                <div class="col-12 mt-3 product-categories-wrap">
                    <ul class="product-category-list row justify-content-center">
                        <?php $i= 0.5; foreach ($terms as $term) {
                            ?>
                            <li class="category-item col-6 col-md-3 mb-4 wow fadeInUp" data-wow-delay="<?php echo $i; ?>s">
                                <a class="position-relative" href="<?php echo get_term_link($term->term_id); ?>">
                                    <div class="category-detail">
                                        <h4 class="entry-category text-center"><?php echo $term->name; ?></h4>
                                        <span class="button-text">همین حالا بخر</span>
                                    </div>
                                    <?php
                                    $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
                                    //$image = wp_get_attachment_image($thumbnail_id);
                                    $image = wp_get_attachment_url( $thumbnail_id );
                                    ?>
                                    <div class="category-image ratio ratio-1x1">
                                        <?php
                                        if ($image) {
                                            echo "<img src='{$image}' alt='{$term->name}' width='275' height='275' />";
                                        }
                                        ?>
                                    </div>
                                </a>
                            </li>
                        <?php $i += 0.25;  } ?>
                    </ul>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
