<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php
    $favicon = get_field('favicon', 'option');

    if ($favicon != '') { ?>
        <link rel="shortcut icon" type="image/png" href="<?php echo $favicon; ?>"/><?php } ?>


    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-00E9Y8QHRJ"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());

        gtag('config', 'G-00E9Y8QHRJ');
    </script>

    <?php wp_head(); ?>
</head>

<?php if (!is_user_logged_in()) {
    $no_login_class = 'noLogin';
} ?>
<body <?php body_class($no_login_class); ?>>

<header class="site-header" id="header">
    <div class="site-header--desktop ">
        <div class="site-header--content d-none d-lg-block">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col col-10 col-lg-9 col-right">
                        <?php
                        /* logo */
                        $logo = get_field('logo', 'option');
                        if ($logo) {
                            echo '<div class="site-logo"><a class="logo-header" href="' . get_bloginfo('url') . '" title="' . get_bloginfo('name') . '">';
                            echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . get_bloginfo('name') . '" />';
                            echo '</a> </div>';
                        }
                        ?>
                        <nav class="site-menu primary-menu horizontal-menu d-none d-lg-block">
                            <?php
                            if (has_nav_menu('main')) {
                                $defaults = array(
                                    'theme_location' => 'main',
                                    'container' => '',
                                    'menu_class' => 'd-flex',
                                    'echo' => true,
                                    'fallback_cb' => 'wp_page_menu',
                                    'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                    'depth' => 3,
                                );
                                wp_nav_menu($defaults);
                            }
                            ?>
                        </nav>
                    </div>
                    <div class="col col-2 col-lg-3 col-left">
                        <div class="quick-button user-login login_wrap">
                            <?php
                            if (!is_user_logged_in()) {
                                echo '<a type="button" class="tiyara-auth-modal-btn" data-bs-toggle="modal" data-bs-target="#tiyara-auth-modal"><i class="klb-user-profile"></i></a>';
                            } else {
                                ?>
                                <ul class="user-loggedin">
                                    <li>
                                        <?php $user_info = get_userdata(get_current_user_id()); ?>
                                        <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>">
                                            <i class="klb-user-profile"></i>
                                            <span> سلام
                                                <?php if ($user_info->last_name != '') {
                                                    echo $user_info->last_name;
                                                } else {
                                                    echo $user_info->user_login;
                                                }
                                                ?>
                                            </span>
                                        </a>
                                        <ul class="submenu_profile m-0 p-0">
                                            <li class="text-start">
                                                <a href="<?php echo wp_logout_url(site_url()); ?>">خروج</a>
                                            </li>
                                        </ul>
                                    </li>
                                </ul>
                            <?php }
                            ?>
                        </div>

                        <div class="quick-button position-relative">
                            <div class="search-button">
                                <i class="klb-search"></i>
                            </div>
                            <div class="search-wrapper search-holder position-absolute">

                                <!--                                <div class="search-holder">-->
                                <div class="search-holder--close">
                                    <i class="klb-x"></i>
                                </div>

                                <form action="<?php get_bloginfo('url'); ?>"
                                      class="search-holder--form klb-ajax-search" role="search" method="get"
                                      id="searchform">
                                    <input class="search-form-input" type="search" value="" name="s" id="s"
                                           placeholder="جستجوی محصول..." autocomplete="off">
                                    <button type="submit"><i class="klb-search"></i></button>
                                    <input type="hidden" name="post_type" value="product">
                                </form>


                                <!--                                </div>-->
                            </div>
                        </div>

                        <div class="quick-button mini-cart">
                            <a href="<?php echo wc_get_cart_url() ?>" class="cart-link">
                                <i class="klb-shop-bag"></i>
                                <span class="counter cart-count-icon" id="cart-count"><?php
                                    $cart_count = WC()->cart->get_cart_contents_count();
                                    echo sprintf(_n('%d', '%d', $cart_count), $cart_count);
                                    ?>
                            </span>
                            </a>
                            <div class="woo-mini-cart">
                                <div class="widget_shopping_cart_content">
                                    <?php woocommerce_mini_cart(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="site-header--mobile d-block d-lg-none">
        <div class="container">
            <div class="row align-items-center">

                <div class="col col-3 col-right pe-0">
                    <div class="quick-button canvas-toggle">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                    <div class="quick-button user-login">
                        <?php
                        if (!is_user_logged_in()) {
                            echo '<a type="button" class="tiyara-auth-modal-btn" data-bs-toggle="modal" data-bs-target="#tiyara-auth-modal"><i class="klb-user-profile"></i></a>';
                        } else {
                            ?>
                            <ul class="user-loggedin">
                                <li>
                                    <?php $user_info = get_userdata(get_current_user_id()); ?>
                                    <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>">
                                        <i class="klb-user-profile"></i>
                                    </a>
                                    <ul class="submenu_profile m-0 p-0">
                                        <li class="text-start">
                                            <a href="<?php echo wp_logout_url(site_url()); ?>">خروج</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        <?php }
                        ?>
                    </div>
                </div>

                <div class="col col-6 col-middle">
                    <?php
                    $logo = get_field('logo', 'option');
                    if ($logo) {
                        echo '<div class="site-logo text-center"><a class="logo-header" href="' . get_bloginfo('url') . '" title="' . get_bloginfo('name') . '">';
                        echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . get_bloginfo('name') . '" />';
                        echo '</a> </div>';
                    }
                    ?>
                </div>

                <div class="col col-3 col-left ps-0">
                    <div class="quick-button position-relative">
                        <div class="search-button">
                            <i class="klb-search"></i>
                        </div>
                        <div class="search-wrapper search-holder position-absolute">

<!--                            <div class="search-holder">-->
                                <div class="search-holder--close">
                                    <i class="klb-x"></i>
                                </div>

                                <form action="<?php get_bloginfo('url'); ?>"
                                      class="search-holder--form klb-ajax-search" role="search" method="get"
                                      id="searchform">
                                    <input class="search-form-input" type="search" value="" name="s" id="s"
                                           placeholder="جستجوی محصول..." autocomplete="off">
                                    <button type="submit"><i class="klb-search"></i></button>
                                    <input type="hidden" name="post_type" value="product">
                                </form>


<!--                            </div>-->
                        </div>

                    </div>


                    <div class="quick-button mini-cart">
                        <a href="<?php echo wc_get_cart_url() ?>" class="cart-link">
                            <i class="klb-shop-bag"></i>
                            <span class="counter cart-count-icon" id="cart-count"><?php
                                $cart_count = WC()->cart->get_cart_contents_count();
                                echo sprintf(_n('%d', '%d', $cart_count), $cart_count);
                                ?>
                            </span>
                        </a>
                        <div class="woo-mini-cart">
                            <div class="widget_shopping_cart_content">
                                <?php woocommerce_mini_cart(); ?>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
</header>

<div class="footer-fix-nav d-block d-lg-none">
    <div class="row mx-0">
        <div class="col">
            <a href="<?php echo get_bloginfo('url'); ?>" title="<?php echo get_bloginfo('name'); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                     stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                     class="feather feather-home">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                    <polyline points="9 22 9 12 15 12 15 22"></polyline>
                </svg>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>"><i class="klb-grid"></i></a>
        </div>
        <div class="col">
            <a href="<?php echo wc_get_cart_url() ?>"><i class="klb-shop-bag"></i><span class="count"><?php
                    $cart_count = WC()->cart->get_cart_contents_count();
                    echo sprintf(_n('%d', '%d', $cart_count), $cart_count);
                    ?></span></a>
        </div>
        <div class="col">
            <?php if (!is_user_logged_in()) { ?>
                <a type="button" class="tiyara-auth-modal-btn" data-bs-toggle="modal"
                   data-bs-target="#tiyara-auth-modal"><i class="klb-user-profile"></i></a>
            <?php } else { ?>
                <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>"><i class="klb-user-profile"></i></a>
            <?php } ?>
        </div>
    </div>
</div>
<main class="main-content">
