<?php
// After setup theme hook adds WC support
function mytheme_add_woocommerce_support()
{
    add_theme_support('woocommerce'); // <<<< here
}

// add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support('wc-product-gallery-lightbox');
add_theme_support('wc-product-gallery-slider');
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');
//Change the order of filter in product archive
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
add_action('template_redirect', 'remove_sidebar_shop');
// Enqueue/Add CSS and JS files
function amd_enqueue()
{
    // here home-page.php is the name of the template where it needs to load
//    if(is_page_template("home-page.php")){
//        wp_enqueue_script('zoom');
    wp_enqueue_script('flexslider');
    wp_enqueue_script('photoswipe-ui-default');
    wp_enqueue_style('photoswipe-default-skin');
    add_action('wp_footer', 'woocommerce_photoswipe');
//    }
}

add_action('wp_enqueue_scripts', 'amd_enqueue');
function remove_sidebar_shop()
{
    if (is_product()) {
        remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar');
    }
}

add_filter('woocommerce_enqueue_styles', '__return_empty_array');
// Remove Marketing Hub menu item
//add_filter('woocommerce_marketing_menu_items', '__return_empty_array');

// Sidebar
function sidebar_woocommerce_filter()
{
    register_sidebar(array(
        'name' => __('سایدبار فروشگاه', 'textdomain'),
        'id' => 'sidebar-woocommerce-filter',
        'before_widget' => '<div id="%1$s" class="widget widget-product %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>'
    ));

    register_sidebar(array(
        'name' => __('فیلترهای فعال', 'textdomain'),
        'id' => 'sidebar-active-filter',
        'before_widget' => '<div id="%1$s" class="widget-product %2$s">',
        'after_widget' => '</div>',
        'before_title' => '',
        'after_title' => ''
    ));
}

add_action('widgets_init', 'sidebar_woocommerce_filter');

/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 20);

function new_loop_shop_per_page($cols)
{
    $cols = 18;
    return $cols;
}

//Remove download from my account
add_filter('woocommerce_account_menu_items', 'perfume_remove_downloads_my_account', 999);

function perfume_remove_downloads_my_account($items)
{
    unset($items['downloads']);
    return $items;
}

add_filter('woocommerce_product_tabs', 'woo_rename_tabs', 98);
function woo_rename_tabs($tabs)
{
    $tabs['description']['title'] = __('اطلاعات تکمیلی');        // Rename the description tab
    $tabs['additional_information']['title'] = __('مشخصات کالا');    // Rename the additional information tab
    return $tabs;
}

add_filter('woocommerce_product_tabs', 'tg_reorder_tabs', 98);
function tg_reorder_tabs($tabs)
{
    $tabs['description']['priority'] = 2; // 2nd - description
    $tabs['additional_information']['priority'] = 1; // 1st - Additional information third
    $tabs['reviews']['priority'] = 3; // 3rd - reviews
    return $tabs;
}


add_filter('woocommerce_account_menu_items', 'custom_my_account_menu_items', 22, 1);
function custom_my_account_menu_items($items)
{
    $items['dashboard'] = __("اطلاعات کاربری", "woocommerce");
    return $items;
}

add_filter('woocommerce_structured_data_product', 'structured_data_product_nulled', 10, 2);
function structured_data_product_nulled($markup, $product)
{
    if (is_product()) {
        $markup = '';
    }
    return $markup;
}

/**
 * Process the checkout
 **/

add_action('woocommerce_checkout_process', 'my_custom_checkout_field_process');
function my_custom_checkout_field_process()
{
    global $woocommerce;

    // Check if set, if its not set add an error. This one is only requite for companies
    if (!(preg_match('/^[0-9]{11}$/D', $_POST['billing_phone']))) {
        wc_add_notice("شماره تلفن شما باید 11 رقم باشد . ورود حروف غیرمجاز است.", 'error');
    }
    // Check if set, if its not set add an error. This one is only requite for companies
    // if (!(preg_match('/^[0-9]{10}$/D', $_POST['billing_postcode']))) {
    //     wc_add_notice("طول کدپستی در صورتحساب باید 10 رقم باشد.", 'error');
    // }
}


add_filter('woocommerce_billing_fields', 'bbloomer_move_checkout_email_field', 10, 1);
function bbloomer_move_checkout_email_field($address_fields)
{
    $address_fields['billing_first_name']['priority'] = 10;
    $address_fields['billing_last_name']['priority'] = 20;
    $address_fields['billing_email']['priority'] = 30;
    $address_fields['billing_phone']['priority'] = 40;
    $address_fields['billing_state']['priority'] = 50;
    $address_fields['billing_city']['priority'] = 60;
    $address_fields['billing_address_1']['priority'] = 70;
    $address_fields['billing_postcode']['priority'] = 80;

    return $address_fields;
}

add_filter('woocommerce_checkout_fields', 'perfume_checkout_fields_styling', 9999);
function perfume_checkout_fields_styling($f)
{

    $f['billing']['billing_state']['class'][0] = 'form-row-first';
    $f['billing']['billing_city']['class'][0] = 'form-row-last';
    $f['billing']['billing_email']['class'][0] = 'form-row-first';
    $f['billing']['billing_phone']['class'][0] = 'form-row-last';

    $f['shipping']['shipping_state']['class'][0] = 'form-row-first';
    $f['shipping']['shipping_city']['class'][0] = 'form-row-last';


    $f['billing']['billing_postcode']['required'] = false;
    $f['shipping']['shipping_postcode']['required'] = false;
    $f['billing']['billing_email']['required'] = false;
    

    return $f;

}


add_filter('woocommerce_save_account_details_required_fields', 'wc_save_account_details_required_fields');
function wc_save_account_details_required_fields($required_fields)
{
    unset($required_fields['account_display_name']);
    return $required_fields;
}


// Change add to cart text on product archives page
add_filter('woocommerce_product_add_to_cart_text', 'woocommerce_add_to_cart_button_text_archives');
function woocommerce_add_to_cart_button_text_archives()
{
    return __('خرید', 'woocommerce');
}


add_action('joe_woocommerce_layered_nav_bottom', 'add_clear_filters');
function add_clear_filters()
{
    $filterreset = $_SERVER['REQUEST_URI'];
    if (strpos($filterreset, '?filter_') !== false | strpos($filterreset, '?min_price') !== false | strpos($filterreset, '?max_price')) {
        $filterreset = strtok($filterreset, '?');
        echo '<div class="clear-filters-container"><a id="woo-clear-filters" href="' . $filterreset . '">حذف همه</a></div>';
    }

}


add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');
add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');

function woocommerce_ajax_add_to_cart()
{

    $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
    $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
    $variation_id = absint($_POST['variation_id']);
    $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
    $product_status = get_post_status($product_id);

    if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

        do_action('woocommerce_ajax_added_to_cart', $product_id);

        if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
            wc_add_to_cart_message(array($product_id => $quantity), true);
        }

        WC_AJAX:: get_refreshed_fragments();
    } else {

        $data = array(
            'error' => true,
            'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));

        echo wp_send_json($data);
    }

    wp_die();
}


add_filter('woocommerce_add_to_cart_fragments', 'refresh_cart_count', 50, 1);
function refresh_cart_count($fragments)
{
    ob_start();
    ?>
    <span class="counter cart-count-icon" id="cart-count"><?php
        $cart_count = WC()->cart->get_cart_contents_count();
        echo sprintf(_n('%d', '%d', $cart_count), $cart_count);
        ?></span>
    <?php
    $fragments['#cart-count'] = ob_get_clean();

    return $fragments;
}


add_filter('woocommerce_variation_is_active', 'bbloomer_grey_out_variations_out_of_stock', 10, 2);

function bbloomer_grey_out_variations_out_of_stock($is_active, $variation)
{
    if (!$variation->is_in_stock()) return false;
    return $is_active;
}

add_filter('woocommerce_catalog_orderby', 'change_sorting_options_order', 5);
function change_sorting_options_order($options)
{
    $options = array(
        'menu_order' => esc_html__('پیش فرض', 'zhinto'),
        'popularity' => esc_html__('محبوب ترین', 'zhinto'),
        'date' => esc_html__('جدیدترین', 'zhinto'),
        'price' => esc_html__('ارزانترین', 'zhinto'),
        'price-desc' => esc_html__('گرانترین', 'zhinto'),
    );

    return $options;
}

function disable_shipping_calc_on_cart($show_shipping)
{
    if (is_cart()) {
        return false;
    }
    return $show_shipping;
}

add_filter('woocommerce_cart_ready_to_calc_shipping', 'disable_shipping_calc_on_cart', 99);

add_filter('woocommerce_return_to_shop_text', 'prefix_store_button');
function prefix_store_button()
{
    $store_button = "همه محصولات"; // Change text as required

    return $store_button;
}

function myset_default_variation_id($product)
{
    if (is_product()) {
        global $product;
        if ($product->is_type('variable')) {
            $variation_ids = $product->get_children();
            $default_attributes = $product->get_default_attributes();
            $default_variation_id = $default_attributes['pa_a5'];
//            $idf_variable = substr($default_variation_id, 0, strpos($default_variation_id, "-"));
            foreach ($product->get_available_variations() as $variation_values) {
                foreach ($variation_values['attributes'] as $key => $attribute_value) {
                    $attribute_name = str_replace('attribute_', '', $key);
                    $default_value = $product->get_variation_default_attribute($attribute_name);
                    if ($default_value == $attribute_value) {
                        $is_default_variation = true;
                    } else {
                        $is_default_variation = false;
                        break; // Stop this loop to start next main lopp
                    }
                }
                if ($is_default_variation) {
                    $variation_id = $variation_values['variation_id'];
                    break; // Stop the main loop
                }
            }
            // echo $variation_id;
            ?>
            <script>

                document.addEventListener('DOMContentLoaded', function () {
                    var defaultVariationId = '<?php echo $default_variation_id ?>';
                    console.log('test:',defaultVariationId);
                    var SelectOpt = document.querySelector('.variations_form .radio-select');
                    if (SelectOpt) {
                        selectOptEl = SelectOpt.querySelectorAll('li input[type="radio"]');
                        for (let el of selectOptEl) {
                            if (el.id.includes(defaultVariationId) && defaultVariationId != '') {
                                var defId = el.id;
                            }
                        }
                    }
                    document.getElementById(defId).click();
                    var variationSelect = document.getElementById('pa_a5');
                    var defaultVariation = '<?php echo $default_variation_id ?>';
                    if (variationSelect) {
                        variationSelect.value = defaultVariation;
                        var event = new Event('change');
                        variationSelect.dispatchEvent(event);
                    }
                });
            </script>
            <?php
        }
    }
}

add_action('wp_footer', 'myset_default_variation_id', 100);


function example_address_free_receipt()
{
    ?>
    <style>
        .order-branding .company-logo {
            max-width: 250px;
            margin-bottom: 10px;
        }

        .shipping-address, .billing-address {
            padding: 20px;
            background: #f7f7f7;
            float: right;
        }

        .shipping-address address, .billing-address address , .company-info * , .shipping-address h3 {
            line-height: 28px;
            font-size: 18px;
            font-family:IRANSans,sans-serif;
        }
        .order-items * {
            font-size: 16px;
            font-family:IRANSans,sans-serif;        
        }

        .order-branding .company-logo img {
            width: 100%;
            height: auto;
        }

        .receipt .order-info {
            display: none;
        }

        .receipt .order-items th.head-item-price,
        .receipt .order-items .product-item-price,
        .receipt .head-price, .receipt .product-price,
        .receipt .order-items tfoot {
            display: none !important;
        }

        .receipt .order-addresses {
            margin-bottom: 2em;
        }
        
        .order-branding, .order-addresses, .order-info, .order-items, .order-notes, .order-thanks, .order-colophon {
            margin-bottom: 2em;
        }
    </style>
    <?php
}

add_action('wcdn_head', 'example_address_free_receipt', 20);

 
// add_filter( 'woocommerce_checkout_fields', 'bbloomer_shipping_phone_checkout' );
 
// function bbloomer_shipping_phone_checkout( $fields ) {
//   $fields['shipping']['shipping_phone'] = array(
//       'label' => 'تلفن همراه',
//       'type' => 'tel',
//       'required' => false,
//       'class' => array( 'form-row-wide' ),
//       'validate' => array( 'phone' ),
//       'autocomplete' => 'tel',
//       'priority' => 25,
//   );
//   return $fields;
// }
  
// add_action( 'woocommerce_admin_order_data_after_shipping_address', 'bbloomer_shipping_phone_checkout_display' );
 
// function bbloomer_shipping_phone_checkout_display( $order ){
//     echo '<p><b>تلفن</b> ' . get_post_meta( $order->get_id(), '_shipping_phone', true ) . '</p>';
// }




add_filter( 'bulk_actions-edit-shop_order', function( $actions ) {

	$actions['csv_download'] = 'دانلود CSV';
	$actions['mobile_csv_download'] = 'دانلود موبایل CSV';
	

	return $actions;

}, 20 );

add_filter( 'handle_bulk_actions-edit-shop_order',
	function( $redirect_to, $action, $post_ids ) {

	if( $action !== 'csv_download' && $action !== 'mobile_csv_download' ) {
		return $redirect_to;
	}

	$args = [
		'csv_download' => ($action === 'csv_download') ? 1 : 0,
        'mobile_csv_download' => ($action === 'mobile_csv_download') ? 1 : 0,
        'post_ids' => implode( ',', $post_ids ),
	];

	return add_query_arg( $args, $redirect_to );

}, 10, 3 );

add_action( 'admin_init', function() {

	if( empty( $_REQUEST['csv_download'] ) && empty( $_REQUEST['mobile_csv_download'] ) ) {
        return;
    }
    $is_mobile_csv = !empty($_REQUEST['mobile_csv_download']);
    $filename = $is_mobile_csv ? 'orders_mobile.csv' : 'orders.csv';
    $header = $is_mobile_csv ? ['Mobile'] : ['Date', 'OrderId', 'Customer', 'Mobile', 'Product', 'Quantity', 'Address'];

	 $data = [$header];
    $post_ids = explode( ',', $_REQUEST['post_ids'] );

    foreach( $post_ids as $order_id ) {
        $order = wc_get_order( $order_id );
        $order_data = $order->get_data();

        if ($is_mobile_csv) {
            // Mobile CSV format
            $data[] = [
                $order_id,
                $order_data['billing']['phone'],
            ];
        } else {
            // Normal CSV format
            foreach( $order->get_items() as $order_item ) {
                $addressVal = !empty($order_data['shipping']['address_1']) ? $order_data['shipping']['address_1'] : $order_data['billing']['address_1'];
                $data[] = [
                    $order->get_date_created()->format( 'm/d/Y' ),
                    $order_id,
                    sprintf('%s %s', $order_data['shipping']['first_name'], $order_data['shipping']['last_name']),
                    $order_data['billing']['phone'],
                    $order_item['name'],
                    $order_item['qty'],
                    $addressVal,
                ];
            }
        }
    }

    // Output CSV
    header( 'Content-Type: text/csv; charset=utf-8' );
    header('Content-Encoding: UTF-8');
    header( 'Content-Disposition: attachment; filename=' . $filename );
    echo "\xEF\xBB\xBF"; // UTF-8 BOM
    $out = fopen( 'php://output', 'w' );
    foreach( $data as $row ) {
        fputcsv( $out, $row );
    }
    fclose( $out );
    exit;

} );


/** Disable Ajax Call from WooCommerce */
add_action( 'wp_enqueue_scripts', 'dequeue_woocommerce_cart_fragments', 11); 
function dequeue_woocommerce_cart_fragments() { if (is_front_page()) wp_dequeue_script('wc-cart-fragments'); }

/** Disable Ajax Call from WooCommerce on front page and posts*/
// add_action( 'wp_enqueue_scripts', 'dequeue_woocommerce_cart_fragments', 11);
// function dequeue_woocommerce_cart_fragments() {
// if (is_front_page() || is_single() ) wp_dequeue_script('wc-cart-fragments');
// }

add_filter( 'woocommerce_show_variation_price', '__return_true' );


function remember_product() {
    // Ensure the file exists before including it
    $remember = get_template_directory() . '/woocommerce/single-product/remember.php';
    include $remember;
  
}
add_action( 'woocommerce_after_single_product_summary', 'remember_product', 17);

function handle_vote() {
    if (isset($_POST['product_id']) && isset($_POST['vote_type'])) {
        $product_id = intval($_POST['product_id']);
        $vote_type = sanitize_text_field($_POST['vote_type']);

        $meta_key = $vote_type === 'like' ? 'like_count' : 'dislike_count';

        $current_count = get_post_meta($product_id, $meta_key, true);
        $new_count = $current_count ? intval($current_count) + 1 : 1;
        update_post_meta($product_id, $meta_key, $new_count);

        wp_send_json_success(array(
            'like_count' => get_post_meta($product_id, 'like_count', true),
            'dislike_count' => get_post_meta($product_id, 'dislike_count', true),
        ));
    }
    wp_die();
}

function handle_vote_change() {
    if (isset($_POST['product_id']) && isset($_POST['vote_type']) && isset($_POST['previous_vote'])) {
        $product_id = intval($_POST['product_id']);
        $vote_type = sanitize_text_field($_POST['vote_type']);
        $previous_vote = sanitize_text_field($_POST['previous_vote']);

        $meta_key = $vote_type === 'like' ? 'like_count' : 'dislike_count';
        $meta_key_opposite = $vote_type === 'like' ? 'dislike_count' : 'like_count';

        // Update the new vote
        $new_count = get_post_meta($product_id, $meta_key, true);
        $new_count = $new_count ? intval($new_count) + 1 : 1;
        update_post_meta($product_id, $meta_key, $new_count);

        // Remove the previous vote
        if ($previous_vote === 'like') {
            $prev_meta_key = 'like_count';
        } else {
            $prev_meta_key = 'dislike_count';
        }
        $prev_count = get_post_meta($product_id, $prev_meta_key, true);
        if ($prev_count) {
            $prev_count = intval($prev_count) - 1;
            update_post_meta($product_id, $prev_meta_key, $prev_count);
        }

        wp_send_json_success(array(
            'like_count' => get_post_meta($product_id, 'like_count', true),
            'dislike_count' => get_post_meta($product_id, 'dislike_count', true),
        ));
    }
    wp_die();
}

add_action('wp_ajax_handle_vote', 'handle_vote');
add_action('wp_ajax_nopriv_handle_vote', 'handle_vote');
add_action('wp_ajax_handle_vote_change', 'handle_vote_change');
add_action('wp_ajax_nopriv_handle_vote_change', 'handle_vote_change');


add_filter( 'default_checkout_billing_country', 'ts_change_default_checkout_country' );
add_filter( 'default_checkout_billing_state', 'ts_change_default_checkout_state' );
function ts_change_default_checkout_country() {
    return null;
}
function ts_change_default_checkout_state() {
    return null;
}





function custom_price_manipulation( $price ) {
   
   $percentage = 0.8;
   $new_price = (float) $price *  (1 + $percentage); 
    return $new_price;

}
add_filter( 'woocommerce_product_get_price', 'custom_price_manipulation' );
add_filter( 'woocommerce_product_get_regular_price', 'custom_price_manipulation' );
add_filter( 'woocommerce_product_get_sale_price', 'custom_sale_price_manipulation' );

function custom_sale_price_manipulation( $price ) {
  if($price!=='') {
    $percentage = 0.8;
    $new_price = (float) $price *  (1 + $percentage);
    return $new_price;
  }
}


// Variations
add_filter('woocommerce_product_variation_get_regular_price', 'ts_custom_price', 99, 2 );
add_filter('woocommerce_product_variation_get_price', 'ts_custom_price', 99, 2 );
add_filter('woocommerce_product_variation_get_sale_price', 'ts_custom_price', 99, 2 );
function ts_custom_price( $price, $product ) {
 if($price!=='') {
   $percentage = 0.8;
   return (float) $price *  (1 + $percentage);
 }
}

// Variable (price range)
add_filter('woocommerce_variation_prices_price', 'ts_custom_variable_price', 99, 3 );
add_filter('woocommerce_variation_prices_regular_price', 'ts_custom_variable_price', 99, 3 );
add_filter('woocommerce_variation_prices_sale_price', 'ts_custom_variable_price', 99, 3 );
function ts_custom_variable_price( $price, $variation, $product ) {
    $percentage = 0.8;
  return (float) $price * (1 + $percentage);
}



add_filter('post_row_actions', 'remove_quick_edit_from_products', 10, 2);

function remove_quick_edit_from_products($actions, $post) {
    // Check if the current post type is a product
    if ($post->post_type === 'product') {
        unset($actions['inline hide-if-no-js']); // Remove "Quick Edit"
    }
    return $actions;
}



add_action( 'woocommerce_product_data_panels', 'bbloomer_custom_product_type_show_price' );
  
function bbloomer_custom_product_type_show_price() {
   ?>
       <script type="text/javascript">
            jQuery(document).ready(function ($) {
                function calculateAdditionalPrice(price) {
                    let additionalPrice = price * 1.80;
                    return Math.round(additionalPrice);
                }
                function updatePriceDisplaySimple() {
                    let $regularPrice = $('#_regular_price');
                    let regularValue = parseFloat($regularPrice.val());
                    let $regularExtra = $('#regular-price-extra');
                    
                    if (regularValue > 0) {
                        if ($regularExtra.length === 0) {
                            $regularPrice.after('<p id="regular-price-extra" style="color: #3b82f6; font-weight: bold;">قیمت + 80%: ' + calculateAdditionalPrice(regularValue) + '</p>');
                        } else {
                            $regularExtra.text('قیمت + 80%: ' + calculateAdditionalPrice(regularValue));
                        }
                    } else {
                        $regularExtra.remove();
                    }
        
                    let $salePrice = $('#_sale_price');
                    let saleValue = parseFloat($salePrice.val());
                    let $saleExtra = $('#sale-price-extra');
                    
                    if (saleValue > 0) {
                        if ($saleExtra.length === 0) {
                            $salePrice.after('<p id="sale-price-extra" style="color: #3b82f6; font-weight: bold;">قیمت + 80%: ' + calculateAdditionalPrice(saleValue) + '</p>');
                        } else {
                            $saleExtra.text('قیمت + 80%: ' + calculateAdditionalPrice(saleValue));
                        }
                    } else {
                        $saleExtra.remove();
                    }
                }
        
                function updatePriceDisplayVariable() {
                    $('.woocommerce_variation').each(function () {
                        let $variation = $(this);
                        let $regularPrice = $variation.find('.wc_input_price[name^="variable_regular_price"]');
                        let $salePrice = $variation.find('.wc_input_price[name^="variable_sale_price"]');
                        
                        let regularValue = parseFloat($regularPrice.val());
                        let $regularExtra = $variation.find('.regular-price-extra');
                        
                        if (regularValue > 0) {
                            if ($regularExtra.length === 0) {
                                $regularPrice.after('<p class="regular-price-extra" style="color: #3b82f6; font-weight: bold;">قیمت + 80%: ' + calculateAdditionalPrice(regularValue) + '</p>');
                            } else {
                                $regularExtra.text('قیمت + 80%: ' + calculateAdditionalPrice(regularValue));
                            }
                        } else {
                            $regularExtra.remove();
                        }
        
                        let saleValue = parseFloat($salePrice.val());
                        let $saleExtra = $variation.find('.sale-price-extra');
                        
                        if (saleValue > 0) {
                            if ($saleExtra.length === 0) {
                                $salePrice.after('<p class="sale-price-extra" style="color: #3b82f6; font-weight: bold;">قیمت + 80%: ' + calculateAdditionalPrice(saleValue) + '</p>');
                            } else {
                                $saleExtra.text('قیمت + 80%: ' + calculateAdditionalPrice(saleValue));
                            }
                        } else {
                            $saleExtra.remove();
                        }
                    });
                }
        
                $('#_regular_price, #_sale_price').on('input', function () {
                    updatePriceDisplaySimple();
                });
        
                $('#variable_product_options').on('woocommerce_variations_loaded', function () {
                    updatePriceDisplayVariable();
                });
        
                $(document).on('input', '.woocommerce_variation .wc_input_price', function () {
                    updatePriceDisplayVariable();
                });
        
                updatePriceDisplaySimple();
                updatePriceDisplayVariable();
            });
        </script>

   <?php
}



function custom_og_image_for_products() {
    if (is_product()) {
        global $post;
        $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');

        if ($thumbnail) {
            echo '<meta property="og:image" content="' . esc_url($thumbnail[0]) . '" />';
            echo '<meta property="og:image:width" content="' . esc_attr($thumbnail[1]) . '" />';
            echo '<meta property="og:image:height" content="' . esc_attr($thumbnail[2]) . '" />';
        }
    }
}
add_action('wp_head', 'custom_og_image_for_products');

// add_filter( 'woocommerce_variation_is_purchasable', 'conditional_variation_is_purchasable', 20, 2 );
// function conditional_variation_is_purchasable( $purchasable, $product ) {

//     $taxonomy  = 'pa_a5';

//     $found = false;

//     // Loop through all product attributes in the variation
//     foreach ( $product->get_variation_attributes() as $variation_attribute => $term_slug ){
//         $attribute_taxonomy = str_replace('attribute_', '', $variation_attribute); // The taxonomy
//         $term = get_term_by( 'slug', $term_slug, $taxonomy ); 
//         if($attribute_taxonomy == $taxonomy && strpos($term->name, 'بطری') !== false ){ // Check if term name contains 'بطری'
//             $found = true;
//             break;
//         }
//     }

//     if( $found )
//         $purchasable = false;

//     return $purchasable;
// }



add_action( 'woocommerce_review_order_before_submit', 'tiyara_add_checkout_refund_money', 9 );
    
function tiyara_add_checkout_refund_money() {
   
woocommerce_form_field( 'refund_money', array(
   'type'          => 'checkbox',
   'class'         => array('form-row privacy'),
   'label_class'   => array('woocommerce-form__label woocommerce-form__label-for-checkbox checkbox'),
   'input_class'   => array('woocommerce-form__input woocommerce-form__input-checkbox input-checkbox'),
   'required'      => true,
   'label'         => 'لطفاً در هنگام خرید دقت فرمایید. در صورت ثبت سفارش اشتباه و درخواست بازگشت وجه، مبلغ پرداختی پس از کسر ۱۵٪ (به‌دلیل هزینه‌های مالیاتی و امور مالیاتی) برگشت داده خواهد شد. همچنین فرآیند بازگشت وجه تا ۷ روز کاری زمان خواهد برد.',
)); 
   
}
   
add_action( 'woocommerce_checkout_process', 'tiyara_not_approved_refund' );
   
function tiyara_not_approved_refund() {
    if ( ! (int) isset( $_POST['refund_money'] ) ) {
        wc_add_notice( __( 'لطفا شرایط درخواست بازگشت وجه را انتخاب کنید.' ), 'error' );
    }
}

?>