<?php
add_action('admin_menu','tiyara_wr_admin_menu');
function tiyara_wr_admin_menu(){
    add_submenu_page(
        'woocommerce',
        'گزارشات اختصاصی',
        'گزارشات اختصاصی',
        'manage_options',
        'tiyara-wr-settings',
        'tiyara_wr_admin_settings_page'
    );
}


add_action('admin_enqueue_scripts','tiyara_wr_admin_enqueue_scripts');
function tiyara_wr_admin_enqueue_scripts($hook_suffix){
    global $pagenow;
    if($pagenow == 'admin.php'){
        if($_GET['page'] == 'tiyara-wr-settings'){
			wp_enqueue_style('persianDatepicker',get_template_directory_uri().'/functions/tiyara-reports/assets/css/persianDatepicker-default.css');
            wp_enqueue_style('tiyara-wr-admin-style',get_template_directory_uri().'/functions/tiyara-reports/assets/css/admin-style9.css');

			wp_enqueue_script('jquery.validate', get_template_directory_uri().'/functions/tiyara-reports/assets/js/jquery.validate.min.js', array('jquery'),'1.0.0',true);
			wp_enqueue_script('persianDatepicker',get_template_directory_uri().'/functions/tiyara-reports/assets/js/persianDatepicker.min.js',array('jquery'),'1.0.0',true);
            wp_enqueue_script('tiyara-wr-admin-script',get_template_directory_uri().'/functions/tiyara-reports/assets/js/admin-script17.js',array('jquery'),'1.0.0',true);
            wp_localize_script('tiyara-wr-admin-script','wr_script_dyn_data',
                array(
                    'admin_ajax'  =>  admin_url('admin-ajax.php')
                )
            );
        }
    }
}


add_action('admin_init','tiyara_wr_admin_init');
function tiyara_wr_admin_init(){
    include 'includes/jdf.php'; 
}


function tiyara_wr_admin_settings_page(){
    if(!current_user_can('manage_options')){
        return;
    }

    $default_tab = null;
    $tab = isset($_GET['tab']) ? esc_html($_GET['tab']) : esc_html($default_tab);

    echo '<div class="tiyara-wr-setting-page-wrap">';
		echo '<h1>گزارشات اختصاصی</h1>';
		
        echo '<ul class="tiyara-wr-menu">';
            echo '<li class="menu-item'.(($tab == null)? ' active':'').'"><a href="?page=tiyara-wr-settings">حجم</a></li>';
            echo '<li class="menu-item'.(($tab == 'product')? ' active':'').'"><a href="?page=tiyara-wr-settings&tab=product">محصول</a></li>';
        echo '</ul>';

        echo '<div class="tiyara-wr-content-wrapper">';
        switch ($tab){
            case "product":
                tiyara_wr_admin_settings_product_page();
                break;
            default:
                tiyara_wr_admin_settings_volume_page();
                break;
        }
        echo '</div>';
    echo '</div>';
}


function tiyara_wr_admin_settings_product_page(){
    ?>
    <div class="product-report-wrapper">
        <div class="notification">
            <p>در فاز بعدی پیاده سازی خواهد شد</p>
        </div>
    </div>
    <?php
}


function tiyara_wr_admin_settings_volume_page(){
    ?>
    <div class="volume-report-wrapper">
        <form method="post" id="volume-report-form" novalidate="novalidate">
            <div class="form-row">
                <div class="form-group col-12 col-md-4 persiandatepicker">
					<label class="text-muted">تاریخ شروع</label>
					<input type="text" name="start_date" id="start_date" class="form-control" autocomplete="off" data-gdate="">
				</div>
				<div class="form-group col-12 col-md-4 persiandatepicker">
					<label class="text-muted">تاریخ پایان</label>
					<input type="text" name="end_date" id="end_date" class="form-control" autocomplete="off" data-gdate="">
				</div>
            </div>
             
            <?php wp_nonce_field('tiyara_wr_volume_nonce','tiyara_wr_volume_nonce_field'); ?>
            <input type="hidden" name="action" value="tiyara_wr_volume_operation"/>
            <button type="submit" class="btn btn-primary mb-4">اعمال</button>
        </form>
    </div>
    <?php 
}
 
 
add_action('wp_ajax_tiyara_wr_volume_operation','tiyara_wr_volume_operation');
add_action('wp_ajax_nopriv_tiyara_wr_volume_operation','tiyara_wr_volume_operation');
function tiyara_wr_volume_operation(){
    $data = array();
	if(is_user_logged_in()){
		if(is_admin()){
			if(current_user_can('manage_options')){
				if(!wp_verify_nonce($_POST['tiyara_wr_volume_nonce_field'], 'tiyara_wr_volume_nonce')){
					$status = 0;
					$error = 'خطا امنیتی رخ داده است';
				}else{
					if($_POST['start_date'] and $_POST['end_date']){
						$start_date = $_POST['start_date'];
						$end_date = $_POST['end_date'];
						$start_date_array = explode("/",$start_date);
						$end_date_array = explode("/",$end_date);
						$start_timestamp = jmktime('0','0','0',$start_date_array[1],$start_date_array[2],$start_date_array[0],'','Asia/Tehran');
						$end_timestamp = jmktime('23','59','59',$end_date_array[1],$end_date_array[2],$end_date_array[0],'','Asia/Tehran');
						
						if($end_timestamp > $start_timestamp){
							$orders = wc_get_orders([
								'limit' => -1,
								'status'  => 'processing',
								'date_created' => $start_timestamp.'...'.$end_timestamp
							]);   
							if(!empty($orders)){
								foreach($orders as $order){
									foreach($order->get_items() as $item){
										if($item->get_type() == 'line_item'){
											$term_slug = $item->get_meta('attribute_pa_a5', true) ?: $item->get_meta('pa_a5',true);
											if($term_slug){
												$term = get_term_by('slug',$term_slug,'pa_a5'); 
												if($term && !is_wp_error($term)){
													$term_id = $term->term_id;
													if(!isset($data['items'][$term_id])){
														$data['items'][$term_id] = [
															'name' => $term->name,
															'total_quantity' => 0,
															'total_price'    => 0
														];
													}

													$data['items'][$term_id]['total_quantity'] += $item->get_quantity();
													$data['items'][$term_id]['total_price'] += $item->get_total();
													
													$volume_type = get_field('volume-type','pa_a5_'.$term_id);
													if($volume_type == 'decant'){
														$data['total']['decant']['name'] = 'مجموع دکانت ها';
														$data['total']['decant']['total_quantity'] += $item->get_quantity();
														$data['total']['decant']['total_price'] += $item->get_total();
													}elseif($volume_type == 'bottle'){
														$data['total']['bottle']['name'] = 'مجموع بطری ها';
														$data['total']['bottle']['total_quantity'] += $item->get_quantity();
														$data['total']['bottle']['total_price'] += $item->get_total();
													}
												} 
											}
										}
									}
								}
							}
							
							if(!empty($data)){
								$data['extra']['order_count'] = count($orders);
								
								$status = 1;
								$error = 'عملیات با موفقیت انجام شد';
							}else{
								$status = 0;
								$error = 'موردی یافت نشد';
							}
						}else{
							$status = 0;
							$error = 'تاریخ پایان باید پس از تاریخ شروع باشد';
						}
					}else{
						$status = 0;
						$error = 'لطفا تاریخ شروع و پایان را انتخاب نمایید';
					} 
				}
			}else{
				$status = 0;
				$error = 'سطح دسترسی شما برای انجام عملیات کافی نمی باشد';
			}
		}else{
			$status = 0;
			$error = 'لطفا وارد حساب کاربری خود شوید';
		} 
	}else{
		$status = 0;
		$error = 'لطفا وارد حساب کاربری خود شوید';
	} 

    $resp = array('status' => $status, 'msg' => $error, 'data' => $data);
    header( "Content-Type: application/json" );
    echo json_encode($resp);
    die();
}