/**
 * External dependencies
 */
import { SVG } from '@wordpress/primitives';

export const ProductGalleryPagerBlockIcon = () => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M5.00018 11L7.00018 11L7.00018 13H5.00018V11ZM11.0002 11L13.0002 11V13H11.0002V11ZM17.0002 11L19.0002 11V13H17.0002V11Z"
			fill="currentColor"
		/>
	</svg>
);

export const PagerDotIcon = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12 12">
		<circle cx="6" cy="6" r="6" fill="black" fillOpacity="0.2" />
	</SVG>
);

export const PagerSelectedDotIcon = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12 12">
		<circle cx="6" cy="6" r="6" fill="black" />
	</SVG>
);

export const PagerSettingsDotIcon = () => (
	<SVG
		width="80"
		height="36"
		viewBox="0 0 80 36"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<circle cx="32.6665" cy="18" r="3" fill="currentColor" />
		<circle
			cx="40.6665"
			cy="18"
			r="2.25"
			stroke="currentColor"
			strokeWidth="1.5"
		/>
		<circle
			cx="48.6665"
			cy="18"
			r="2.25"
			stroke="currentColor"
			strokeWidth="1.5"
		/>
	</SVG>
);

export const PagerSettingsDigitsIcon = () => (
	<SVG
		width="80"
		height="36"
		viewBox="0 0 80 36"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M30.1417 22H31.9288V14.9541H30.1417L28.3497 16.1748V17.7178L30.0489 16.5703H30.1417V22ZM36.9771 22H41.7231V21.0674H38.4663V20.9697L39.9604 19.4805C41.2397 18.2109 41.6108 17.5957 41.6108 16.7949V16.7803C41.6108 15.6182 40.644 14.7832 39.3306 14.7832C37.9146 14.7832 36.9185 15.6914 36.9136 16.9805L36.9233 16.9902H37.9487L37.9536 16.9756C37.9536 16.2041 38.481 15.6865 39.272 15.6865C40.0435 15.6865 40.5171 16.1943 40.5171 16.8828V16.8975C40.5171 17.4688 40.2485 17.8301 39.3159 18.8018L36.9771 21.2578V22ZM48.7392 22.1318C50.2333 22.1318 51.2929 21.2627 51.2929 20.0518V20.042C51.2929 19.0557 50.5995 18.4307 49.5644 18.3379V18.3135C50.4237 18.1328 51.0487 17.5469 51.0487 16.6729V16.6631C51.0487 15.5742 50.1308 14.8223 48.7294 14.8223C47.3524 14.8223 46.4149 15.6084 46.3075 16.7949L46.3026 16.8486H47.328L47.3329 16.7998C47.4013 16.1357 47.9481 15.7207 48.7294 15.7207C49.5253 15.7207 49.9843 16.1211 49.9843 16.8047V16.8145C49.9843 17.4688 49.4374 17.9424 48.6317 17.9424H47.8065V18.792H48.6659C49.6034 18.792 50.1796 19.2363 50.1796 20.0322V20.042C50.1796 20.7354 49.5985 21.2188 48.7392 21.2188C47.8651 21.2188 47.2743 20.7695 47.206 20.1299L47.2011 20.0811H46.1562L46.161 20.1396C46.2538 21.3066 47.2353 22.1318 48.7392 22.1318Z"
			fill="currentColor"
		/>
	</SVG>
);
