<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
}
?>
<div <?php wc_product_class('product-item', $product); ?> >

    <div class="product-content">
        <div class="product-media position-relative">
            <?php woocommerce_show_product_loop_sale_flash(); ?>
            <figure class="entry-media">
                <a href="<?php echo get_permalink(); ?>">
                    <?php if(get_field('product_bg')!='') { ?>
                    <span class="second-thumbnail"
                          style="background-image: url(<?php echo get_field('product_bg'); ?>);"></span>
                    <?php } ?>
                    <?php woocommerce_template_loop_product_thumbnail(); ?>

                </a>
                <div class="product-action">
                    <!--<a href="<?php //echo get_the_ID(); ?>" data-bs-toggle="modal" data-bs-target="#Modal"-->
                    <!--   class="detail-bnt quickview-button" tabindex="0">-->
                    <!--    <i class="klb-eye"></i>-->
                    <!--</a>-->
                    <?php
                    echo do_shortcode('[ti_wishlists_addtowishlist]');
                    ?>
                </div>
                <?php if (get_field('perfume_type')) { ?>
                    <div class="product-type <?php echo get_field('perfume_type'); ?>">
                    </div>
                <?php } ?>
            </figure>
        </div>
            <div class="entry-wrapper">
                <h2 class="entry-name woocommerce-loop-product__title"><a
                            href="<?php echo get_permalink(); ?>"
                            title="<?php echo get_the_title(); ?>"><?php echo get_the_title(); ?></a></h2>
                <?php echo woocommerce_template_loop_price(); ?>
                <div class="mt-3 text-center">
                    <?php //if ($product->is_in_stock()) :
                        woocommerce_template_loop_add_to_cart();
                    //endif; ?>
                </div>
            </div>
    </div>

    <?php
    /**
     * Hook: woocommerce_after_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_close - 5
     * @hooked woocommerce_template_loop_add_to_cart - 10
     */
    do_action('woocommerce_after_shop_loop_item'); ?>
</div>


