<?php


function socialshares()
{
    $title = urlencode(get_the_title());
    $url = urlencode(get_permalink());
    $homeurl = urlencode(get_bloginfo('url'));
    $desc = urlencode(get_the_excerpt());
    $share = '<span class="hide-mobile">اشتراک گذاری : </span><ul class="share-social">';
    $share .= '';
    $share .= '<li><a href="https://www.facebook.com/sharer/sharer.php?u=' . $url . '&amp;t=' . $title . '" title="Share on Facebook" target="_blank" rel=" nofollow noopener" class="facebook"><i class="klb-facebook"></i></a></li>';
    $share .= '<li><a href="https://twitter.com/intent/tweet?source=' . $url . '&amp;text=' . $title . ':' . $homeurl . '" target="_blank" title="Tweet" rel="nofollow noopener" class="twitter"><i class="klb-twitter"></i></a></li>';
//    $share .= '<li ><a href="https://telegram.me/share/url?url=' . $url . '&amp;text=' . $title . ':' . $homeurl . '" title="telegram" rel="nofollow noopener" target="_blank" class="telegram"><i class="klb-telegram"></i></a></li>';
    $share .= '<li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=' . $url . '&amp;title=' . $title . '&amp;summary=' . $desc . '&amp;source=' . $homeurl . '" target="_blank" title="Share on LinkedIn" class="linkedin" rel="nofollow noopener" ><i class="klb-linkedin"></i></a></li>';
    $share .= '<li><span><i class="icon-share"></i></span></li>';
    $share .= '</ul>';
    return $share;
}

function socilaLinlks()
{
    if (have_rows('social_links', 'option')):
        $share = '<ul class="social-list d-inline-flex justify-content-center justify-content-md-end">';
        while (have_rows('social_links', 'option')) : the_row();
            $social_name = get_sub_field('social_name', 'option');
            $social_url = get_sub_field('social_url', 'option');
            if ($social_url != '') {
                $share .= '<li>';
                $share .= '<a href = "' . $social_url . '" target = "_blank" class="' . $social_name . '" >';
                $share .= '<span class="social-icon" ><i class="klb-' . strtolower($social_name) . '" ></i ></span >';
//                $share .= '<span class="social-text" >' . $social_name . '</span >';
                $share .= '<span class="social-label" > Follow</span >';
                $share .= '</a >';
                $share .= '</li>';
            }
        endwhile;
        $share .= '</ul>';
        return $share;
    endif;
}

// Pagination
function pagination_bar($custom_query)
{
    $total_pages = $custom_query->max_num_pages;
    //echo $total_pages;
    $big = 999999999; // need an unlikely integer
    if ($total_pages > 1) {
        $current_page = max(1, get_query_var('paged'));
        echo paginate_links(array(
            'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format' => '?paged=%#%',
            'prev_text' => __('قبلی'),
            'next_text' => __('بعدی'),
            'before_page_number' => '',
            'current' => $current_page,
            'total' => $total_pages,
        ));
    }
}

function getPostViews($postID)
{
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if ($count == '') {
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count . '';
}

/*
 * Set post views count using post meta
 */
function setPostViews($postID)
{
    $countKey = 'post_views_count';
    $count = get_post_meta($postID, $countKey, true);
    if ($count == '') {
        $count = 0;
        delete_post_meta($postID, $countKey);
        add_post_meta($postID, $countKey, '0');
    } else {
        $count++;
        update_post_meta($postID, $countKey, $count);
    }
}

function popular_post_register_widget()
{
    register_widget('popular_post_widget');
}

add_action('widgets_init', 'popular_post_register_widget');

class popular_post_widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            'popular_post_widget',
            __('پربازدیدترین مقالات', ' popular_post_widget_domain'),
            array('description' => __('مقالات پربازدید', 'popular_post_widget_domain'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
        if (!empty($title))
            echo $args['before_title'] . $title . $args['after_title'];
        $args2 = array(
            'post_type' => 'post',
            'posts_per_page' => '3',
            'meta_key' => 'post_views_count',
            'order' => 'DESC',
            'orderby' => 'meta_value_num',
        );
        $query = new WP_Query($args2);
        if ($query->have_posts()):
            while ($query->have_posts()) : $query->the_post();
                echo '<div class="popular-item d-flex position-relative">';
                echo '<div class="popular-item-image">';
                if (has_post_thumbnail()) {
                    the_post_thumbnail('thumbnail');
                }
                echo '</div>';
                echo '<div class="popular-item-content">';
                echo '<a class="stretched-link" href="' . get_permalink() . '">';
                the_title();
                echo '</a>';
                echo '</div>';
                echo '</div>';
            endwhile;
        endif;
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        if (isset($instance['title']))
            $title = $instance['title'];
        else
            $title = __('Default Title', 'popular_post_widget_domain');
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>"/>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}


function social_register_widget()
{
    register_widget('social_widget');
}

add_action('widgets_init', 'social_register_widget');

class social_widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
// widget ID
            'social_widget',
// widget name
            __('شبکه های اجتماعی', ' social_widget_domain'),
// widget description
            array('description' => __('شبکه های اجتماعی', 'social_widget_domain'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
//if title is present
        if (!empty($title))
            echo $args['before_title'] . $title . $args['after_title'];
//output
        if (have_rows('social_links', 'option')):
            echo '<div class="site-social">
				<ul>';
            while (have_rows('social_links', 'option')) : the_row();
                $social_name = get_sub_field('social_name', 'option');
                $social_url = get_sub_field('social_url', 'option');
                if ($social_url != '') {
                    echo '<li>
						<a href="' . $social_url . '" target="_blank" class="' . $social_name . '">
						  <span class="social-icon"><i class="klb-' . strtolower($social_name) . '"></i></span>
						  <span class="social-text">' . $social_name . '</span>
						  <span class="social-label">دنبال کردن</span>
						</a>
					  </li>';
                }
            endwhile;
            echo '</ul>
			  </div>';
        endif;
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        if (isset($instance['title']))
            $title = $instance['title'];
        else
            $title = __(' ', 'social_widget_domain');
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>"/>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}

?>
